﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Godziny
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            Hide();
            timer1.Enabled = false;
        }

        private void oToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Show();
            timer1.Enabled = true;
        }

        private void zamknijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            notifyIcon1.Visible = false;
            Close();
        }

        private void notifyIcon1_MouseMove(object sender, MouseEventArgs e)
        {
            notifyIcon1.Text = "Godziny .NET 2 (" + DateTime.Now.ToShortTimeString() + ")";
        }

        private void notifyIcon1_DoubleClick(object sender, EventArgs e)
        {
            string s = "Aktualna data: " + DateTime.Today.ToLongDateString();
            string[] DniTygodnia = { "Niedziela", "Poniedziałek", "Wtorek", "Środa", "Czwartek", "Piątek", "Sobota" };
            byte numerDniaTygodnia = (byte)DateTime.Now.DayOfWeek;
            s += "\nDzień tygodnia: " + DniTygodnia[numerDniaTygodnia];
            s += "\nDzień roku: " + DateTime.Now.DayOfYear;
            s += "\nAktualny czas: " + DateTime.Now.ToLongTimeString();
            s += "\n\n(c) Jacek Matulewski 2008";
            notifyIcon1.BalloonTipText = s;
            notifyIcon1.ShowBalloonTip(1000);
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            DateTime nastepnaPelnaGodzina = new DateTime(DateTime.Now.Year,
                                        DateTime.Now.Month,
                                        DateTime.Now.Day,
                                        DateTime.Now.Hour + 1,
                                        0, 0, 0);
            long ileMilisekundDoPelnejGodziny = (nastepnaPelnaGodzina.Ticks - DateTime.Now.Ticks) / 10000;
            timer2.Interval = (int)ileMilisekundDoPelnejGodziny;
            timer2.Enabled = true;
        }

        private void timer2_Tick(object sender, EventArgs e)
        {
            timer2.Interval = 3600000;  //1000ms*60sek*60min
            (new System.Media.SoundPlayer("Godziny.wav")).Play();
            notifyIcon1_DoubleClick(sender, e); //dymek
        }
    }
}
