program cw4_38;
{ Program pokazujacy podstawowe dzialania w kolejce: }
{ ustawianie sie w kolejce i obsluzenie kolejki.     }
{ Katalog r4_09 : 4_38.pas                           }

uses
  Crt;

type
  TWskaznik = ^TElement;
  TElement  = record
                Liczba : Byte;
                Nast  : TWskaznik;
              end;

var
  Kolejka : TWskaznik;
  Liczba : Byte;
  Znak : Char;

procedure Ustaw (Liczba: Byte);
{ Procedura ustawia w element w kolejce. }
var
  E, Pop, Nast : TWskaznik;
begin
  New (E);
  E^.Liczba := Liczba;
  if Kolejka = nil then
  begin
    E^.Nast := Kolejka; Kolejka := E;
  end
  else
  begin
    Pop := Kolejka; Nast := Kolejka^.Nast;
    while Nast <> nil do
    begin
      Pop := Nast;
      Nast := Nast^.Nast;
    end;
    E^.Nast := Nast;
    Pop^.Nast := E;
  end;
end; {------------------------------ Ustaw -}

function Obsluz: Byte;
{ Funkcja zwraca wartosc pierwszego elementu z kolejki }
{ do obsluzenia, jednoczesnie go z niej usuwajac.      }
var
  E : TWskaznik;

begin
  if Kolejka = nil then
    Obsluz := 0
  else
  begin
    E := Kolejka;
    Obsluz := E^.Liczba;
    Kolejka := E^.Nast;
  end;
end; {------------------------------------------ Obsluz -}

procedure WypiszKolejke;
{ Procedura wypisuje wszystkie elementy kolejki.   }
var
  E : TWskaznik;
begin
  E := Kolejka;
  while E <> nil do
  begin
    Write (E^.Liczba, ' ');
    E := E^.Nast;
  end;
end; {----------------------------- WypiszKolejke -}

procedure UsunKolejke;
{ Procedura usuwa wszystkie elementy kolejki.   }
var
  E1, E2 : TWskaznik;
begin
  E1 := Kolejka;
  while E1 <> nil do
  begin
    E2 := E1;
    E1 := E1^.Nast;
    Dispose(E2);
  end;
end; {----------------------------- UsunKolejke -}

begin
  Kolejka := nil;

  repeat
    ClrScr;
    Write ('Kolejka: ');
    WypiszKolejke;
    Writeln; Writeln ('U - ustaw w kolejce, O - obsluz, K - koniec');
    Znak := UpCase(ReadKey);
    case Znak of
      'U' : begin
              repeat
                Write ('Podaj liczbe z zakresu (1..255): ');
                Readln (Liczba);
              until Liczba > 0;
              Ustaw (Liczba);
            end;
      'O' : begin
              Liczba := Obsluz;
              if Liczba = 0 then
                Writeln ('Nie ma czego obslugiwac, kolejka pusta.')
              else
                Writeln ('Element do obsluzenia: ', Liczba);
            end;
    end;
    if (Znak = 'U') or (Znak = 'O') then
    begin
      Write ('Nowa kolejka: '); WypiszKolejke;
      Writeln; Writeln ('Wcisnij Enter'); Readln;
    end;
    
  until Znak = 'K';
  UsunKolejke;
end.
