program cw4_36;
{ Program pokazujacy podstawowe dzialania w slowniku }
{ dodawanie elementu w odpowiednim pod wzgledem      }
{ alfabetycznym miejscu.                             }
{ Katalog r4_09 : 4_36.pp                            }

uses
  Crt;

type
  TWskaznik = ^TElement;
  TElement  = record
                Liczba : Real;
                Nast   : TWskaznik;
              end;

var
  Stos : TWskaznik;
  Znak : Char;
  Licznik, LicznikCyfr, Liczba: Integer;
  Wynik, Liczba1, Liczba2 : Real;
  Tablica : String;

function Operacja (liczba1 : Real; liczba2 : Real; znak : Char) : Real;
{ Procedura oblicza wynik dziaania artymetycznego na dwch podanych liczbach }
{ w zalenoci od wybranego typu operacji }
begin
  case znak of
    '*' : Operacja := liczba1 * liczba2;
    '/' : Operacja := liczba1 / liczba2;
    '+' : Operacja := liczba1 + liczba2;
    '-' : Operacja := liczba1 - liczba2;
  end;
end; {------------------------------------- Oblicz -}

procedure Push(liczba : Real);
{ Procedura tworzy nowy element stosu, kopiuje do niego podan liczb }
{ oraz ustawia go na szczycie stosu }
var
  E : TWskaznik;
begin
  New (E);
  E^.Liczba := liczba;
  if Stos <> nil then
    E^.Nast := Stos
  else
    E^.Nast := nil;
  Stos := E;
end; {------------------------------------- Push -}

function Pop() : Real;
{ Funkcja zdejmuje element ze stosu i zwraca warto liczby wewntrz niego }
var
  Liczba : Real;
  E : TWskaznik;
begin
  if Stos = nil then
    Pop := -1
  else
  begin
    Liczba := Stos^.Liczba;
    E := Stos;
    Stos := E^.nast;
    Dispose (E);
    Pop := Liczba;
  end;
end; {------------------------------------- Pop -}

begin
  Stos := nil;
  Licznik := 1;
  LicznikCyfr := 0;

  ClrScr;
  Writeln ('Wpisz dziaania matematyczne w notacji Postfix (wcinij Enter by zakoczy: ');
  repeat
  repeat
    Znak := ReadKey;
    Write(Znak);
    Tablica[Licznik] := Znak;
    Tablica[0] := Chr(Licznik); { Pierwszy element acucha znakw musi zawiera jego dugo }

    { Jeli ostatnio wczytany znak jest liczb }
    if (Znak >= '0') AND (Znak <= '9') then Inc(LicznikCyfr);

    { Jeli ostatnio wczytany znak jest pusty, a poprzednie byy cyframi }
    if (Znak = ' ') AND (LicznikCyfr > 0) then
      begin
        { Konwersja znakw tworzcych liczb do postaci numerycznej }
        Val ( Copy (Tablica, Licznik - LicznikCyfr, LicznikCyfr), Liczba);
        Push (Liczba);
        LicznikCyfr := 0;
      end;

    { Jeli ostatnio wczytany znak reprezentuj symbol operacji arytmetycznej }
    if (Znak = '+') OR (Znak = '-') OR (Znak = '/') OR (Znak = '*') then
    begin
      Liczba1 := Pop;
      Liczba2 := Pop;
      Wynik := Operacja (Liczba2, Liczba1, Znak);
      Push (Wynik);
    end;
    Inc(Licznik);
  until Znak = #13;
  until Znak = #13;
  WriteLn();
  Write('Wynik operacji:');
  WriteLn(Wynik:10:2);
end.
