program cw4_66d;
{ Program pokazuje dzialanie prostej ksiazki telefo- }
{ nicznej z podstawowymi operacjami: wyswietlania,   }
{ dodawania, poprawiania i usuwania wpisow. Program  }
{ jest tylko szkicem, ktory mozna rozbudowywac o do- }
{ datkowe funkcje i czynic obsluge wygodniejszyma.   }
{ Katalog r4_11 : 4_66d.pas                          }

uses
  Crt;

type
  TOsoba = record  { Struktura pamietajaca dane o osobie }
             Imie, Nazwisko, Telefon : String [30];
           end;

const
  PlikZAdresami = 'NOTES.DTA';

function Istnieje (S : String) : Boolean;
{ Funkcja sprawdzajaca, czy istnieje plik }
{ o nazwie S.                             }
var
  F : Text;
begin
  Assign (F, S);
  {$I-} Reset (F); {$I+}
  if IOResult=0 then
  begin
    Close (F);
    Istnieje := True;
  end
  else
    Istnieje := False
end; {------------------------- Istnieje -}

function WypiszKsiazke : Integer;
{ Procedura wypisuje zawartosc ksiazki adresowej. }
var
  F : file of TOsoba;
  Osoba : TOsoba;
  I : Integer;
begin
  I := 0;

  if Istnieje (PlikZAdresami) then
  begin
    Assign (F, PlikZAdresami); Reset (F);
    while not Eof (F) do
    begin
      Inc (I); Read (F, Osoba);
      Write (I:3, ' ', Osoba.Imie+' '+Osoba.Nazwisko);
      GotoXY (40, WhereY); Writeln (Osoba.Telefon);
    end;
    Close (F);
  end;

  if I=0 then
    Writeln ('Baza adresowa jest pusta');

  WypiszKsiazke := I;
end; {---------------------------- WypiszKsiazke -}

procedure DodajOsobe (Osoba : TOsoba);
{ Procedura dodaje osobe do ksiazki adresowej. }
var
  F : file of TOsoba;
begin
  if Istnieje (PlikZAdresami) then
  begin
    Assign (F, PlikZAdresami); Reset (F);
    Seek (F, FileSize(F));
  end
  else
  begin
    Assign (F, PlikZAdresami); Rewrite (F);
  end;
  Write (F, Osoba);
  close (F);
end; {---------------------------- DodajOsobe -}

procedure EdytujOsobe (Osoba : TOsoba; Numer : Integer);
{ Procedura poprawia osobe w ksiazce adresowej. }
var
  F : file of TOsoba;
begin
  Assign (F, PlikZAdresami); Reset (F);
  Seek (F, Numer-1);
  Write (F, Osoba);
  close (F);
end; {---------------------------- EdytujOsobe -}

procedure UsunOsobe (Numer : Integer);
{ Procedura usuwa osobe z ksiazki adresowej. }
{ Zauwaz, ze da sie to zrobic w jednym pliku }
{ nawet usuwajac ze srodka. Nie zawsze jest  }
{ to jednak najlepsze rozwiazanie.           }
var
  F : file of TOsoba;
  Osoba : TOsoba;
  I : Integer;
begin
  Assign (F, PlikZAdresami); Reset (F);
  I := Numer;
  Seek (F, I);
  while not eof (F) do
  begin
    Read (F, Osoba); Seek (F, I-1); Write (F, Osoba);
    Inc (I); Seek (F, I);
  end;
  Seek (F, I-1);
  Truncate (F);
  close (F);
end; {--------------------------- UsunOsobe -}

var
  Znak : Char;
  Osoba : TOsoba;
  LiczbaOsob, Numer : Integer;

begin
  repeat
    ClrScr;
    LiczbaOsob := WypiszKsiazke;
    Writeln;
    Writeln ('D - dodaj osobe, U - usun osobe, P - popraw osobe, K - koniec');
    Readln (Znak); Znak := Upcase (Znak);
    case Znak of
      'D': begin
             Writeln;
             Write ('  Podaj imie:           '); Readln (Osoba.Imie);
             Write ('  Podaj nazwisko:       '); Readln (Osoba.Nazwisko);
             Write ('  Podaj numer telefonu: '); Readln (Osoba.Telefon);
             DodajOsobe (Osoba);
           end;
      'U': begin
             Writeln;
             repeat
               Write ('  Podaj numer osoby (1-', LiczbaOsob, '), 0 aby zaniechac: ');
               Readln (Numer);
             until (Numer>=0) and (Numer <= LiczbaOsob);
             if (Numer <> 0) then
               UsunOsobe (Numer);
           end;
      'P': begin
             Writeln;
             repeat
               Write ('  Podaj numer osoby (1-', LiczbaOsob, '), 0 aby zaniechac: ');
               Readln (Numer);
             until (Numer>=0) and (Numer <= LiczbaOsob);
             if (Numer <> 0) then
             begin
               Write ('  Podaj nowe imie:           '); Readln (Osoba.Imie);
               Write ('  Podaj nowe nazwisko:       '); Readln (Osoba.Nazwisko);
               Write ('  Podaj nowy numer telefonu: '); Readln (Osoba.Telefon);
               EdytujOsobe (Osoba, Numer);
             end;
           end;
    end
  until Znak = 'K';
end.
