unit unit4_69;
{ Modul zawiera dodatkowo procedure RysujPomiar   }
{ wyswietlajaca wartosc funkcji dla zadanego x    }
{ Procedura Rysuj umozliwia dodatkowo przesuwanie }
{ pomiaru klawiszami dla roznych x                }
{ Katalog r4_11 : unit4_69.pas                    }
interface

procedure Rysuj;

implementation
uses
  Crt, Graph;

const
  TypWykresu : Integer = 1;
  Pocz_x    = 180;
  Pocz_y    = 460;
  Wielkosc  = 440;
  Min_wsp   = -5;
  Max_wsp   = 5;
  Jednostka = Wielkosc/(Max_wsp-Min_wsp);
  Krok      = (Max_wsp-Min_wsp)/Wielkosc;
  Pomiar : Integer = Pocz_x+1;

type
  TOrientacja = (Poziomo, Pionowo);

function Funkcja(Nr : Integer; X : Real) : Real;
begin
  case Nr of
    1 : Funkcja := Sin(X);
    2 : Funkcja := Cos(x);
    3 : Funkcja := ArcTan(x);
    4 : Funkcja := Exp(x);
    5 : Funkcja := Int(x);
    6 : Funkcja := Frac(x);
    7 : Funkcja := Sqr(x);
    8 : Funkcja := Abs(x);
  end;
end;

procedure RysujPomiar;
var
  X, Y : Real;
  J : Integer;
  Napis : String;
begin
  SetWriteMode(XorPut);
  SetLineStyle(DashedLn, 0, NormWidth);
  SetColor(LightBlue);
  Line(Pomiar, Pocz_y, Pomiar, Pocz_y-Wielkosc);
  X := Min_wsp+Krok*(Pomiar-Pocz_x);
  Y := Funkcja(TypWykresu, X);
  J := Round(-Y*Jednostka+Pocz_y+Min_wsp*Jednostka);
  Line(Pocz_x, J, Pocz_x+Wielkosc, J);
  SetLineStyle(SolidLn, 0, NormWidth);
  SetWriteMode(NormalPut);

  SetViewPort(30, 420, 150, 460, True);
  SetTextStyle(DefaultFont, HorizDir, 1);
  ClearViewPort;
  Str(X:6:3, Napis);
  OutTextXY(10, 10, 'X = '+napis);
  Str(Y:6:3, Napis);
  OutTextXY(10, 25, 'Y = '+napis);
  SetViewPort(0, 0, GetMaxX, GetMaxY, True);
end;

procedure RysujWykres(Kolor : Integer);
var
  X, Y : Real;
  I, J : Integer;
begin
  X := Min_wsp;
  for I := Pocz_x to Pocz_x+Wielkosc do
  begin
    Y := Funkcja(TypWykresu, X);
    J := Round(-Y*Jednostka+Pocz_y+Min_wsp*Jednostka);
    PutPixel(I, J, Kolor);
    X := X+Krok;
  end;
end;

procedure Os(Orientacja : TOrientacja; Wsp_x, Wsp_y, Dlugosc, Min, Maks : Integer);
var
  I, Przesun : Integer;
  Napis : String;
begin
  SetColor(White);
  SetTextStyle(DefaultFont, HorizDir, 1);
  case Orientacja of
    Poziomo : Line(Wsp_x, Wsp_y, Wsp_x+Dlugosc, Wsp_y);
    Pionowo : Line(Wsp_x, Wsp_y, Wsp_x, Wsp_y-Dlugosc);
  end;
  for I := Min to Maks do
  begin
    Przesun := Round((I-Min)*Dlugosc/(Maks-Min));
    Str(I, Napis);
    case Orientacja of
      Poziomo:
      begin
        Line(Wsp_x+Przesun, Wsp_y-3, Wsp_x+Przesun, Wsp_y+3);
        OutTextXY(Wsp_x+Przesun-(TextWidth(Napis) div 2), Wsp_y+6, Napis);
      end;
      Pionowo:
      begin
        Line(Wsp_x-3, Wsp_y-Przesun, Wsp_x+3, Wsp_y-Przesun);
        OutTextXY(Wsp_x-TextWidth(Napis)-4, Wsp_y-Przesun-3, Napis);
      end;
    end;
  end;
end;

procedure RysujLegende;
const
  Legenda : array[0..10] of String =
  ('Esc - koniec', '1 - Sin(x)',   '2 - Cos(x)',   '3 - ArcTg(x)',
   '4 - Exp(x)',   '5 - Int(x)',   '6 - Frac(x)',  '7 - Sqr(x)',
   '8 - Abs(x)',   '<-,->  - ',    ' - pomiar');
var
  I : Integer;
begin
  SetTextStyle(TriplexFont, HorizDir, 2);
  for I := 0 to 10 do
  begin
    if I = TypWykresu then
      SetColor(White)
    else
      SetColor(LightGreen);
    OutTextXY(10, 10+35*I, Legenda[I]);
  end;
end;

procedure Rysuj;
var
  Znak        : Char;
  Koniec      : Boolean;
  Nowy_pomiar : Integer;
begin
  Znak := '1';
  RysujPomiar;
  Koniec := False;
  while not Koniec do
  begin
    if Znak <> #0 then
    begin
      if Znak in ['1'..'8'] then
      begin
        RysujPomiar;
        RysujWykres(Black);
        TypWykresu := Ord(Znak)-Ord('0');
        RysujWykres(Yellow);
        Os(Poziomo, Pocz_x, Pocz_y, Wielkosc, Min_wsp, Max_wsp);
        Os(Pionowo, Pocz_x, Pocz_y, Wielkosc, Min_wsp, Max_wsp);
        RysujLegende;
        RysujPomiar;
      end;
    end
    else
    begin
      Znak := ReadKey;
      if Znak = #75 then Nowy_pomiar := Pomiar-1;
      if Znak = #77 then Nowy_pomiar := Pomiar+1;
      if (Nowy_pomiar >= Pocz_x) and (Nowy_pomiar <= Pocz_x+Wielkosc) then
      begin
        RysujPomiar;
        Pomiar := Nowy_pomiar;
        RysujPomiar;
      end;
    end;
    Znak := ReadKey;
    if Znak = #27 then Koniec := True;
  end;
end;

end.