program cw4_64d;
{ Program tworzy na dysku plik KALEND.TXT z kalendarzem }
{ na podany w zmiennej Rok rok.                         }
{ Katalog r4_11 : 4_64d.pas                             }

uses
  Crt;

type
  { Typ rekordowy, w ktorym bedzie pamietana data }
  TData = record
            Dzien, Miesiac : Byte;
            Rok : Integer;
          end;

  TDniTygodnia = (niedziela, poniedzialek, wtorek, sroda,
                  czwartek, piatek, sobota);
  TKalendarz = Array [1..12, 1..42] of Byte;

const
  NazwyMiesiecy : array [1..12] of String =
                 ('styczen', 'luty', 'marzec', 'kwiecien',
                  'maj', 'czerwiec', 'lipiec', 'sierpien',
                  'wrzesien', 'pazdziernik', 'listopad', 'grudzien');

function LiczbaDniWRoku (Rok : Integer) : Integer;
{ Funkcja podaje liczbe dni w roku Rok. }
begin
  if (Rok mod 4 = 0) and 
     ((Rok mod 100 <> 0) or (Rok mod 400 = 0)) then
    LiczbaDniWRoku := 366 { rok przestepny }
  else
    LiczbaDniWRoku := 365 { rok nie jest przestepny }
end; {----------------------------- LiczbaDniWRoku -}

function LiczbaDniWMiesiacu (Miesiac : Byte; Rok : Integer) : Byte;
{ Funkcja podaje liczbe dni w miesiacu Miesiac roku Rok. }
begin
  case Miesiac of
    1, 3, 5, 7, 8, 10, 12: LiczbaDniWMiesiacu := 31;
    2: if LiczbaDniWRoku (Rok) = 366 then
         LiczbaDniWMiesiacu := 29
       else
         LiczbaDniWMiesiacu := 28
    else
      LiczbaDniWMiesiacu := 30
  end;
end; {---------------------------------------- LiczbaDniWMiesiacu -}

function LiczbaDniDoKoncaMiesiaca (Data : TData) : Byte;
{ Funkcja podaje liczbe dni od podanej daty do konca biezacego }
{ miesiaca.                                                    }
begin
  LiczbaDniDoKoncaMiesiaca := LiczbaDniWMiesiacu (Data.Miesiac, Data.Rok)-Data.Dzien;
end; {------------------------------ LiczbaDniDoKoncaMiesiaca -}

function LiczbaDniDoKoncaRoku (Data : TData) : Integer;
{ Funkcja podaje liczbe dni od podanej daty do konca biezacego }
{ roku.                                                        }

var
  Liczba : Integer;
  I : Byte;
begin
  Liczba := LiczbaDniDoKoncaMiesiaca (Data);
  for I := Data.Miesiac+1 to 12 do
    Liczba := Liczba + LiczbaDniWMiesiacu (I, Data.Rok);
  LiczbaDniDoKoncaRoku := Liczba
end; {---------------------------------- LiczbaDniDoKoncaRoku -}

function DataWieksza (D1, D2 : TData) : Boolean;
{ Funkcja sprawdza, czy data D1 jest wieksza od daty D2. }
var
  D : Boolean;
begin
  D := False;
  if D1.Rok > D2.Rok then
    D := True
  else
    if D1.Rok = D2.Rok then
      if D1.Miesiac > D2.Miesiac then
        D := True
      else
        if D1.Miesiac = D2.Miesiac then
          if D1.Dzien > D2.Dzien then
            D := True;
  DataWieksza := D;
end; {------------------------------------- DataWieksza -}

function LiczbaDniPomiedzyDatami (D1, D2 : TData) : LongInt;
{ Funkcja podaje liczbe dni od dnia D1 do D2. }
var
  Liczba : LongInt;
  I, Mnoznik : Integer;
  Pom : TData;
begin
  if DataWieksza (D1, D2) then
  begin
    Mnoznik := -1;
    Pom := D1; D1 := D2; D2 := Pom;
  end
  else
    Mnoznik := 1;
  Liczba := LiczbaDniDoKoncaRoku (D1);
  for I := D1.Rok+1 to D2.Rok do
    Liczba := Liczba + LiczbaDniWRoku (I);
  Liczba := Liczba - LiczbaDniDoKoncaRoku (D2);
  LiczbaDniPomiedzyDatami := Mnoznik * Liczba;
end; {-------------------------- LiczbaDniPomiedzyDatami -}

function DzienTygodnia (D : TData) : TDniTygodnia;
{ Funkcja oblicza, jakim dniem tygodnia jest wskazany dnien }
{ opierajac sie na informacji, ze 1.1.1800 byl sroda.       }
var
  DStart : TData;
  Liczba : LongInt;
begin
  DStart.Dzien := 1; DStart.Miesiac := 1; DStart.Rok := 1800;
  Liczba := (LiczbaDniPomiedzyDatami (DStart, D) + 3) mod 7;
  DzienTygodnia := TDniTygodnia (Liczba);
end; {-------------------------------------- DzienTygodnia -}

procedure DrukujTrzyMiesiace (var F : Text; Pocz : Byte;
                              Kalendarz : TKalendarz);
{ Procedura drukuje kolejne trzy miesiace, rozpoczynajac }
{ od Pocz.                                               }
var
  I, J, K, Start : Byte;
begin
  Writeln (F, ' po wt sr cz pt so ni      po wt sr cz pt so ni      po wt sr cz pt so ni');
  for J := 0 to 5 do
    for I := Pocz to Pocz+2 do
    begin
      for K := 1 to 7 do
        if Kalendarz[I, J*7+K] = 0 then
          Write (F, '   ')
        else Write (F, Kalendarz[I, J*7+K]:3);
      if I<Pocz+2 then Write (F, '     ') else Writeln(F);
    end;
  Writeln (F);
end; {------------------------------------------------- DrukujTrzyMiesiace -}

var
  D : TData;
  Dzien : TDniTygodnia;
  Rok : Integer;
  I, J, Start : Byte;
  F : Text;
  Kalendarz : TKalendarz;

begin
  ClrScr;
  Rok := 2000;
  FillChar (Kalendarz, SizeOf(Kalendarz), 0);
  { To byl ciekawy sposob zerowania duzej zmiennej. Nalezy uwazac! }

  { Teraz zapelnimy zmienna Kalendarz. Dla kazdego miesiaca }
  { bedziepamietac uklad charaktrystyczny dla drukowanego   }
  { kalendarza, przy zalozeniu, ze pierwszym dniem tygodnia }
  { jest poniedzialek.                                      }
  for I := 1 to 12 do
  begin
    D.Dzien := 1; D.Miesiac := I; D.Rok := Rok;
    Dzien := DzienTygodnia (D);
    Start := Ord (Dzien); if Start = 0 then Start := 7;
    for J := 1 to LiczbaDniWMiesiacu (I, Rok) do
      Kalendarz [I, J+Start-1] := J;
  end;

  Assign (F, 'KALEND.TXT'); Rewrite (F);
  Writeln (F, Rok:39);
  Writeln (F, '====':39);
  Writeln (F);
  Writeln (F, '       STYCZEN                     LUTY                      MARZEC      ');
  DrukujTrzyMiesiace (F, 1, Kalendarz);
  Writeln (F, '       KWIEIEN                      MAJ                     CZERWIEC     ');
  DrukujTrzyMiesiace (F, 4, Kalendarz);
  Writeln (F, '        LIPIEC                   SIERPIEN                   WRZESIEN     ');
  DrukujTrzyMiesiace (F, 7, Kalendarz);
  Writeln (F, '     PAZDZIERNIK                 LISTOPAD                   GRUDZIEN     ');
  DrukujTrzyMiesiace (F, 10, Kalendarz);

  Close (F);
  Writeln ('Zapisano plik KALEND.TXT');
end.
