#include "naglowki.h"
/*wyświetlanie atrybutów*/
void getUrl (xmlDocPtr doc, xmlNodePtr cur){
	xmlChar *url;
	xmlChar *rel;
	cur = cur->xmlChildrenNode;
	while (cur !=NULL){
	    if ((!xmlStrcmp(cur->name, (const xmlChar *)"link"))){
	      rel = xmlGetProp(cur, "rel");
	      url = xmlGetProp(cur, "href");
	      printf("url: 		%s\n\n", url);
	      xmlFree(url);
	    }
	    cur = cur->next;
	}
	return;
}
void parseEntry (xmlDocPtr doc, xmlNodePtr cur) {

	xmlChar *key;
/*pobieramy pierwszy węzeł dziecko*/
	cur = cur->xmlChildrenNode;
/*iteracja po węzłach w poszukiwaniu keyword*/
	while (cur != NULL) {

	    if ((!xmlStrcmp(cur->name, (const xmlChar *)"title"))) {
/* do cur->xmlChildrenNode "wpisany " jest tekst  elementu. xmlNodeListGetString - do przetworzenia tekstu - alokuje pamięć, więc potem trzeba użyć xmlFree*/
		    key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
		    printf("title: 		%s\n", key);
		    xmlFree(key);
 	    }
 	    if((!xmlStrcmp(cur->name, (const xmlChar *)"updated"))){
		    key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
		    printf("updated: 	%s\n", key);
		    getUrl(doc, cur);
		    xmlFree(key);
	    }

	cur = cur->next;
	}
    return;
}

void parseDoc(char *docname) {

	/*deklaracja wskaźnika wskazującego na parsowany dokument*/
	xmlDocPtr doc;
	/*deklaracja wskaźnika do węzła (potrzebny do interakcji z poszczególnymi węzłami)*/
	xmlNodePtr cur;

	doc = xmlParseFile(docname);
	/*sprawdzenie czy dokument został poprawnie sparsowany*/
	if (doc == NULL ) {
		fprintf(stderr,"Dokument nie został sparsowany poprawnie. \n");
		return;
	}
	/*przetwarzanie root element*/
	cur = xmlDocGetRootElement(doc);
	/*sprawdzanie czy dokument coś zawiera*/
	if (cur == NULL) {
		fprintf(stderr,"Pusty dokument\n");
		xmlFreeDoc(doc);
		return;
	}
	/*sprawdzenie czy dokument ma właściwy typ - root == story*/
	if (xmlStrcmp(cur->name, (const xmlChar *) "feed")) {
		fprintf(stderr,"Nie ten typ pliku, root node != feed");
		xmlFreeDoc(doc);
		return;
	}
/*przetwarzanie zawartości elementu*/
/*pobranie pierwszego węzła - w tej chwili wskazuje na roota*/
	cur = cur->xmlChildrenNode;
/*iteracje po wszystkich węzłach "dzieciach" "story", szuka elementu storyinfo*/
	while (cur != NULL) {
/*xmlStrcmp - do porównywania stringów*/
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"entry"))){
			parseEntry (doc, cur);
			getUrl(doc, cur);
		}

	cur = cur->next;
	}

	xmlFreeDoc(doc);
	return;
}


