#include "zapisdobazy.h"
#include "ui_zapisdobazy.h"
#include <QString>
#include <QtSql/QSqlDatabase>
#include <QtSql/QSqlQuery>
#include <QMessageBox>
#include <QTextCodec>
#include <QtDebug>
ZapisDoBazy::ZapisDoBazy(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::ZapisDoBazy)
{
    ui->setupUi(this);
    QTextCodec::setCodecForCStrings(QTextCodec::codecForName("UTF-8"));
}

ZapisDoBazy::~ZapisDoBazy()
{
    delete ui;
}

void ZapisDoBazy::on_pushButtonZapisz_clicked()
{
    QString n,c,l;
    int ile;
    float cena_;
    n=ui->lineEditNazwa->text();
    c=ui->lineEditCena->text();
    l=ui->lineEditSztuki->text();
    cena_=c.toFloat();
    ile=l.toInt();

    int a=zapiszDoBazy(n, cena_, ile);

 qDebug() << a;
    if(a==0){QMessageBox wiadomosc;
        wiadomosc.setText("Dane zostały zapisane");
        wiadomosc.exec();}
    wyczysc();

}
int ZapisDoBazy::zapiszDoBazy(QString nazwa, float cena, int ile)
{

    QSqlDatabase baza = QSqlDatabase::addDatabase("QMYSQL");
    baza.setHostName("localhost");
    //w miejsca ???? wpisać odpowiednie dane
    baza.setUserName("????");
    baza.setPassword("????");
    baza.setDatabaseName("Magazyn");

    if (!baza.open()) {
        QMessageBox::critical(0, qApp->tr("Nie mozna otworzyc bazy danych."),
                qApp->tr("Nie mozna zapisać do bazy.\n\n"
                         "Kliknij Cancel aby wyjsc."), QMessageBox::Cancel);
            return -1;

    }
    QSqlQuery zapytanie;
    zapytanie.prepare("INSERT INTO Towar(nazwa,cena,ile_sztuk)"
                      "VALUES (:naz, :ce, :ile)");
    zapytanie.bindValue(":naz",nazwa);
    zapytanie.bindValue(":ce", cena);
    zapytanie.bindValue(":ile", ile);
    zapytanie.exec();
    baza.close();
return 0;
}
void ZapisDoBazy::wyczysc()
{
    ui->lineEditNazwa->setText(" ");;
    ui->lineEditCena->setText(" ");
    ui->lineEditSztuki->setText(" ");
}

//http://doc.trolltech.com/4.2/sql-cachedtable.html
