#include "huffman.h"

using namespace std;

Huffman::Huffman()
{//zerowana tablica 256 elementw - 1 znak to 1 bajt. W pliku bd zliczne bajty. Indeks z tablicy odpowiada wartoci znaku.
    for(int i=0;i<256;i++)
        all[i] = NULL;
}

Huffman::~Huffman()
{//usuwanie elementw z tablicy
    for(int i=0;i<256;i++)
        if(all[i] != NULL) delete all[i];
}

void Huffman::pakuj(std::ifstream *ifs, ofstream *stream) {

    Element *root =  budujDrzewo(ifs);//"obrabianie" danych z pliku
    ifs->clear();//czyszczenie bufora bdw
    ifs->seekg(0,ios::beg); // przewiniecie pliku do poczatku
    zapiszDrzewo(ifs,stream, root);//zapisywanie drzewa

}

void Huffman::segreguj(int &a,int &b, int wartA, int wartB)
{
    if(wartB<wartA) {
        int pom = a;
        a = b;
        b = pom;
    }
}

//ifs - dane kodowane
void Huffman::zapiszDrzewo(ifstream *ifs,ofstream *stream, Element *elem)
{
    stream->write((char*)(&iloscZnakow), sizeof(int)); //zapisuje ilosc znakow
    //zapisanie wystpowania znakw
    for(int i=0; i<256;i++) {
            stream->write((char*)(&(all[i]->wart)), sizeof(int));
            stream->flush();
            }
    Builder builder(stream);
    //zapisaie treci
    char buf;
    while(!ifs->eof()) {
        ifs->read(&buf, sizeof(char));
        zapiszZnak(&builder, all[buf]);
    }
    builder.flush();//zwrcenie zakodowanego pliku (jest zapisany) - strumie jest zamykany w main
}

void Huffman::zapiszZnak(Builder *builder, Element *pom) 
{
     if(pom->rodzic) 
     {
         zapiszZnak(builder, pom->rodzic);
         builder->add(pom->rodzic->p == pom); //dla prawego dziecka zapisuje 1 dla lewego 0      
     }
}

void Huffman::usunDrzewo(Element *elem) //usuwanie drzewa - kasowanie elementw
{
    if(elem!=NULL)
    {
        usunDrzewo(elem->p);
        usunDrzewo(elem->l);
        delete elem;              
    } 
}


//ifs - dane do statystyk
Element * Huffman::budujDrzewo(ifstream *ifs)//przyjmuje jako parametr "plik"
{
    Element * tab[256];
    int wielk_tab=255;
//nowe elementy. element zawiera warto znaku i czsto jego wystpowania. Zawiera odnoniki do rodzica i potomkw.
    for(int i=0;i<=wielk_tab;i++)
    {
        tab[i] = new Element(0,i);
        all[i] = tab[i];
    }
    char buf;
    int counter = 0;
    while(true) {//zapis odczytanych danych z bufora do tablicy all
        ifs->read(&buf, sizeof(char));
        if(ifs->eof()) break;
        all[buf]->wart++; // ilo wystpie konkretnego znaku
        counter++;//zwikszanie licznika - ilo znakw
    }
    
    this->iloscZnakow = counter;
    
    return budujDrzewo(tab,wielk_tab);//zbudowanie drzewa z "obrobionych danych"
}


Element * Huffman::budujDrzewo(Element ** tab, int wielk_tab) {
    Element * pomel;
    for (int j=wielk_tab; j>=0; j--)
        if(tab[j]->wart==0) //wyrzucenie wszystkich elementw zerowych
        {
            pomel=tab[j];
            tab[j]=tab[wielk_tab];
            wielk_tab--;
        }
    if(wielk_tab==0) return tab[0];
    if(wielk_tab<0) return NULL;

    int el1, el2;
    Element *pom = NULL;
    while(wielk_tab > 0)
    {
        el1 = 0;//najmniejszy element (index) w tablicy
        el2 = 1;//drugi najmniejszy (index) element
        //pobieranie dwch elementw i ich wartoci
        //jeeli pierwsza warto jest wiksza od drugij to zamienia elementy
        segreguj(el1,el2,tab[el1]->wart,tab[el2]->wart);
        //segregowanie elementw od drugiego elementu do koca tablicy
        for (int i=2;i<wielk_tab;i++) {//wyszukiwanie dwch najmniejszych elementw do poczenia
            if(tab[i]->wart<tab[el2]->wart)
            {
                el2 = i;
                segreguj(el1,el2,tab[el1]->wart,tab[el2]->wart);
            }
        } 
        //utworzenie nowego elementu - dla dwch elementw o mniejszych wartociach robi si element
        pom = new Element(tab[el1]->wart + tab[el2]->wart, 0);
        pom->l = tab[el1];
        pom->p = tab[el2];
        tab[el1]->rodzic = pom;
        tab[el2]->rodzic = pom;
        tab[el1] = pom;
        tab[el2] = tab[wielk_tab];//ostatni element
        wielk_tab--;//zmniejszanie tablicy

    }
    return tab[0];//zwraca zbudowane drzewo
}

Builder::Builder(std::ofstream *stream)
{
    this->stream = stream;
    this->pom = (char)0;
    this->wsk = 7;
}

void Builder::add(bool bit)//dodaje kolejne bity, jeeli uzbiera si bajt jest on wpisywany do pliku
{
    if(this->wsk<0)
    {
        this->flush();
        this->wsk=7;
        this->pom=(char)0;
    }
    if(bit) this->pom |= 1<<this->wsk;
    this->wsk--;
}

void Builder::flush()//zapisuje bajt do pliku (jeeli nie jest pusty)
{
   if(this->wsk!=7) stream->write(&pom, sizeof(char));
}

Reader::Reader(std::ifstream *stream)
{
    this->stream = stream;
    this->pom = (char)0;
    this->wsk = -1;
}

bool Reader::hasNext() 
{
    if(wsk>=0) return true;
    if(stream->get(pom)) {
        wsk=7;
        return true;
    }
    return false;
}

bool Reader::getNext() 
{
    return pom >> wsk-- & 1;
}
