#include <GL/glut.h> // plik nagłówkowy dla biblioteki GLUT
#include <GL/gl.h> // plik nagłówkowy dla biblioteki OpenGL32
#include <GL/glu.h> // plik nagłówkowy dla biblioteki Glu32
/* author: kaya*
Prosty szablon dla Code::Blocks - tworzenie okna.
*/
//funkcja rysująca
void rysuj(void)
{

    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    glColor3f(0.0,1.0,1.0);
    /* Można wykasować poniższy trójkąt i umieścić tutaj swój własny kod*/
    glBegin(GL_TRIANGLES);
        glVertex3f(-1.0,-1.0,0.0);
		glVertex3f(1.0,0.0,0.0);
		glVertex3f(0.0,1.0,0.0);
    glEnd();
    glutSwapBuffers();
}
//funkcja odpowiedzialna za zmianę rozmiaru okna
static void resize(int width, int height)
{
    const float ar = (float) width / (float) height;

    glViewport(0, 0, width, height);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    //glFrustum(-ar, ar, -1.0, 1.0, 2.0, 100.0);

    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity() ;
}
static void idle(void)
{
    glutPostRedisplay();
}

int main(int argc, char **argv)
{
    glutInit(&argc, argv);
    //rozmiary okna
    glutInitWindowSize(320,320);
    //gdzie będzie się wyświetlało
    glutInitWindowPosition(0,0);
	glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH);
	glutCreateWindow("Szablon");

    //zmiana rozmiaru okna (przeliczenie wszystkiego)
    glutReshapeFunc(resize);
    //rejestracja "wywołań"
    glutDisplayFunc(rysuj);
    glutIdleFunc(idle);
	//ustawienie koloru tła na biały
    glClearColor(1.0,1.0,1.0,1.0);
    // umożliwia "czyszczenie" bufora głębokości
    glClearDepth(1.0);
    //typ testu głębokości
    glDepthFunc(GL_LESS);
    //umożliwienie testu
    glEnable(GL_DEPTH_TEST);
    //umozliwnienie płynnego cieniowania koloru
    glShadeModel(GL_SMOOTH);

    //rozpoczęcie pretwarzania
    glutMainLoop();

    return EXIT_SUCCESS; //bez tego nie będzie się dobrze wyświetlało w Code::Blocks
}
