#include "listaapp.h"
#include "ui_listaapp.h"
#include <QListWidgetItem>
#include <QMessageBox>
#include <QSettings>
#include <QPoint>
#include <QTextCodec>
ListaApp::ListaApp(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::ListaApp)
{
    ui->setupUi(this);
    QTextCodec::setCodecForCStrings(QTextCodec::codecForName("UTF-8"));
    odczytajUstawienia();
    ui->lLista->addItem("C++");
    ui->lLista->addItem("Perl");

}

ListaApp::~ListaApp()
{
    delete ui;
}

void ListaApp::on_pDodaj_clicked()
{
    QString al = ui->lineEditDane->text();
    if(QString::compare(al,"")==0)
    {
        QMessageBox::warning(0,qApp->trUtf8("Brak Danych"), qApp->trUtf8("Wprowadź dane"), QMessageBox::Ok);
    }
    else {
    ui->lLista->addItem(al);
    ui->lineEditDane->setText(" ");
}
}

void ListaApp::on_pUsun_clicked()
{
    ui->lLista->takeItem(ui->lLista->row(ui->lLista->currentItem()));

}

void ListaApp::on_pushButton_clicked()
{
    if (zamkniecie()==1)
    {
    zapiszUstawienia();
    QApplication::exit();
    }

}
void ListaApp::zapiszUstawienia()
{
    QSettings wlasciwosci("kaya*","Dodawanie do listy");
    wlasciwosci.beginGroup("App");
              wlasciwosci.setValue("pozycja", pos());
              wlasciwosci.setValue("zlisty","HTML");
    wlasciwosci.endGroup();
}
void ListaApp::odczytajUstawienia()
{
    QString ll;
    QSettings wlasciwosci("kaya*","Dodawanie do listy");
    wlasciwosci.beginGroup("App");
        //move( wlasciwosci.value("pozycja", QPoint(200,200)).toPoint());
        move( wlasciwosci.value("pozycja").toPoint());
        ll=wlasciwosci.value("zlisty").toString();
        wlasciwosci.endGroup();
    ui->lLista->addItem(ll);
}
int ListaApp::zamkniecie()
{
    QMessageBox okienko;
        okienko.setWindowTitle("Uwaga!");
        okienko.setIcon(QMessageBox::Question);
        okienko.setText(trUtf8("Zamykanie aplikacji."));
        okienko.setInformativeText("Czy naprawdę zamknąć aplikację?");
        okienko.setStandardButtons(QMessageBox::Cancel|QMessageBox::Ok);
     int w = okienko.exec();
     switch(w){
        case QMessageBox::Cancel: return 0;
            break;
        case QMessageBox::Ok: return 1;
            break;
     default:
            return 0;
            break;
     }
     return 0;
}
