#include "przelicznik.h"
#include "ui_przelicznik.h"
#include <QComboBox>
#include <QTextCodec>
#include <QString>
#include <QMessageBox>

Przelicznik::Przelicznik(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::Przelicznik)
{
    QTextCodec::setCodecForCStrings(QTextCodec::codecForName("UTF-8"));
    ui->setupUi(this);
    //Z
    ui->comboBoxZ->addItem("m2");
    ui->comboBoxZ->addItem("a");
    //Na
    ui->comboBoxNa->addItem("m2");
    ui->comboBoxNa->addItem("a");
    ui->comboBoxNa->addItem("ha");


}

Przelicznik::~Przelicznik()
{
    delete ui;

}

void Przelicznik::on_pushButtonPrzelicz_clicked()
{
    double wy, liczba;

    QString j1, j2,l;
    l=ui->lineEditZ->text();
    if((QString::compare(l, "")==0))
    {

        QMessageBox::critical(0, qApp->trUtf8("Brak danych."),
                       qApp->trUtf8("Brakuje danych.\n\n"
                                "Kliknij Cancel aby wyjść."), QMessageBox::Cancel);

    }
    else if(l.contains(QRegExp("\\D"))==true)
    {
        QMessageBox::critical(0, qApp->tr("Zle dane."),
                       qApp->tr("Podaj cyfre.\n\n"
                                "Kliknij Cancel aby wyjsc."), QMessageBox::Cancel);
    }
    else
    {

    liczba=l.toDouble();
    //QString::contains()
    j1=ui->comboBoxZ->currentText();
    j2=ui->comboBoxNa->currentText();
    if (QString::compare(j1,j2)==0)
    {
        wy=liczba;

    }
    else if(((QString::compare(j1,"m2")==0) && ((QString::compare(j2, "a")==0))))
        {
            // z metrów na ary
              wy=liczba/100.0;

        }
    else if(((QString::compare(j1,"m2")==0) && ((QString::compare(j2, "ha")==0))))
    {
        wy=liczba/10000.0;
    }
    else if(((QString::compare(j1,"a")==0) && ((QString::compare(j2, "m2")==0))))
        {
            // z arów na metry
              wy=liczba*100.0;

        }
    else if(((QString::compare(j1,"a")==0) && ((QString::compare(j2, "ha")==0))))
    {
        wy=liczba/100.0;
    }

    ui->labelLiczba->setNum(liczba);
    j1.append("   to   ");
    ui->labelJednostka_1->setText(j1);
    ui->labelWynik->setNum(wy);
    ui->labelJednostka_2->setText(j2);
}
}
