package layout;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Layout implements ActionListener {
    HashMap okna = null;
    HashMap przyciski = null;
    HashMap etykiety = null;

    public Layout() {
        okna = new HashMap();
        przyciski = new HashMap();
        etykiety = new HashMap();
    }
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        Layout layout = new Layout();
        
        try {
            Xml.parse(layout, "./res/a.xml");
        } catch (ParserConfigurationException ex) {
            Logger.getLogger(Layout.class.getName()).log(Level.SEVERE, null, ex);
        } catch (SAXException ex) {
            Logger.getLogger(Layout.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(Layout.class.getName()).log(Level.SEVERE, null, ex);
        }
        
    }

    public void addEtykieta(Etykieta etykieta) {
        etykiety.put(etykieta.getId(), etykieta);//klucz id etykiety, etykieta jest obiektem przechowywanym
    }
    
    public void addOkno(Okno okno) {
        okna.put(okno.getId(), okno);
    }
    
    public void addPrzycisk(Przycisk przycisk) {
        przycisk.addActionListener(this);
        przyciski.put(przycisk.getId(), przycisk);
    }
    
    @Override
    public void actionPerformed(ActionEvent e) {
        Przycisk przycisk = (Przycisk)e.getSource();
        Iterator<String> it = przycisk.iterator();//do listy dowiązań
        
        while(it.hasNext()) {
            String dowiazanie = it.next();
            if(dowiazanie==null || dowiazanie.equals(""))
                continue;
            Etykieta etykieta = (Etykieta) etykiety.get(dowiazanie);
            if(etykieta!=null) {
                etykieta.setText("Wciśnięto przycisk: "+przycisk.getId());
            }
        }
    }
}
