/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.animations;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.M3G;
import com.sun.lwuit.animations.Transition;
import javax.microedition.m3g.AnimationController;
import javax.microedition.m3g.AnimationTrack;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.KeyframeSequence;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;
import javax.microedition.m3g.World;

public final class Transition3D
extends Transition
implements M3G.Callback {
    private static final int FLY_IN = 2;
    private static final int ROTATION = 1;
    private static final int CUBE_ROTATION = 3;
    private static final int STATIC_ROTATION = 4;
    private static final int SWING_IN = 5;
    private static final int VERTICAL_CUBE_ROTATION = 6;
    private int transitionType;
    private World world;
    private long startTime;
    private int duration = 1000;
    private static int maxTextureResolution = -1;
    private boolean rotateRight;
    private boolean highQualityMode;
    private boolean firstFinished;
    private int clipX;
    private int clipY;
    private int clipW;
    private int clipH;
    private boolean firstTime = true;

    private Transition3D(int transitionType) {
        this.transitionType = transitionType;
    }

    public void cleanup() {
        super.cleanup();
        this.world = null;
        try {
            Graphics3D.getInstance().setCamera(null, null);
            Graphics3D.getInstance().resetLights();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.firstTime = true;
    }

    private static void initMaxTexture() {
        maxTextureResolution = M3G.getInstance().getMaxTextureDimension();
        if (Display.getInstance().isLightMode()) {
            maxTextureResolution = maxTextureResolution > 128 ? 128 : 64;
        }
    }

    public static void setMaxTextureDimension(int size) {
        maxTextureResolution = size;
    }

    public static Transition3D createRotation(int duration, boolean rotateRight) {
        Transition3D.initMaxTexture();
        Transition3D t3d = new Transition3D(1);
        t3d.duration = duration;
        t3d.rotateRight = rotateRight;
        return t3d;
    }

    public static Transition3D createStaticRotation(int duration, boolean rotateRight) {
        Transition3D.initMaxTexture();
        Transition3D t3d = new Transition3D(4);
        t3d.duration = duration;
        t3d.rotateRight = rotateRight;
        return t3d;
    }

    public static Transition3D createSwingIn(int duration) {
        return Transition3D.createSwingIn(duration, true);
    }

    public static Transition3D createSwingIn(int duration, boolean topDown) {
        Transition3D.initMaxTexture();
        Transition3D t3d = new Transition3D(5);
        t3d.duration = duration;
        t3d.rotateRight = topDown;
        return t3d;
    }

    public static Transition3D createCube(int duration, boolean rotateRight) {
        Transition3D.initMaxTexture();
        Transition3D t3d = new Transition3D(3);
        t3d.duration = duration;
        t3d.rotateRight = rotateRight;
        return t3d;
    }

    public static Transition3D createVerticalCube(int duration, boolean rotateDown) {
        Transition3D.initMaxTexture();
        Transition3D t3d = new Transition3D(6);
        t3d.duration = duration;
        t3d.rotateRight = rotateDown;
        return t3d;
    }

    public static Transition3D createFlyIn(int duration) {
        Transition3D.initMaxTexture();
        Transition3D t3d = new Transition3D(2);
        t3d.duration = duration;
        return t3d;
    }

    public Transition copy(boolean reverse) {
        Transition3D t3d = new Transition3D(this.transitionType);
        t3d.duration = this.duration;
        t3d.rotateRight = reverse ? !this.rotateRight : this.rotateRight;
        return t3d;
    }

    public boolean animate() {
        boolean finished;
        if (this.world == null) {
            return false;
        }
        long time = System.currentTimeMillis();
        int current = (int)(time - this.startTime);
        this.world.animate(current);
        if (this.firstFinished) {
            return false;
        }
        boolean bl = finished = current >= this.duration;
        if (finished && !this.firstFinished) {
            this.firstFinished = true;
        }
        return true;
    }

    public void paint(Graphics g) {
        if (this.world == null) {
            return;
        }
        if (this.firstFinished) {
            this.getDestination().paintComponent(g);
            return;
        }
        Component c = this.getSource();
        int titleHeight = 0;
        if (c instanceof Dialog) {
            Dialog dlg = (Dialog)c;
            c = dlg.getContentPane();
            titleHeight = dlg.getTitleComponent().getHeight();
        } else if (this.getDestination() instanceof Dialog) {
            Dialog dlg = (Dialog)this.getDestination();
            c = dlg.getContentPane();
            titleHeight = dlg.getTitleComponent().getHeight();
        } else if (this.firstTime) {
            this.startTime = System.currentTimeMillis();
            this.firstTime = false;
        }
        if (this.firstTime) {
            this.startTime = System.currentTimeMillis();
            this.firstTime = false;
            if (this.getDestination() instanceof Dialog) {
                this.getSource().paintComponent(g);
            } else {
                this.getDestination().paintComponent(g);
            }
        }
        this.clipY = c.getAbsoluteY() - titleHeight;
        this.clipX = c.getAbsoluteX();
        this.clipW = c.getWidth();
        this.clipH = c.getHeight() + titleHeight;
        g.setClip(this.clipX, this.clipY, this.clipW, this.clipH);
        M3G.getInstance().renderM3G(g, false, 2, this);
    }

    public void initTransition() {
        try {
            Component source = this.getSource();
            Component dest = this.getDestination();
            if (source == null || dest == null || source.getWidth() < 4 || source.getHeight() < 4 || dest.getWidth() < 4 || dest.getHeight() < 4) {
                return;
            }
            this.firstFinished = false;
            this.world = new World();
            Camera camera = new Camera();
            camera.setPerspective(30.0f, 1.0f, 1.0f, 45.0f);
            Transform cameraTransform = new Transform();
            Graphics3D g3d = Graphics3D.getInstance();
            g3d.setCamera(camera, cameraTransform);
            Group group = new Group();
            this.world.addChild((Node)group);
            this.world.setActiveCamera(camera);
            group.addChild((Node)camera);
            Background background3D = new Background();
            background3D.setColorClearEnable(true);
            background3D.setDepthClearEnable(true);
            background3D.setColor(0xFF000000 | source.getStyle().getBgColor());
            this.world.setBackground(background3D);
            switch (this.transitionType) {
                case 2: {
                    Mesh destMesh = this.createMesh(dest);
                    group.addChild((Node)destMesh);
                    this.createFlyIn(destMesh, background3D);
                    break;
                }
                case 3: {
                    Mesh destMesh = this.createMesh(dest);
                    this.createCubeRotation(group, destMesh, false);
                    break;
                }
                case 6: {
                    Mesh destMesh = this.createMesh(dest);
                    this.createCubeRotation(group, destMesh, true);
                    break;
                }
                case 1: {
                    Mesh destMesh = this.createMesh(dest);
                    group.addChild((Node)destMesh);
                    this.createRotation(group, destMesh);
                    break;
                }
                case 4: 
                case 5: {
                    Mesh destMesh;
                    if (source instanceof Dialog) {
                        destMesh = this.createMesh(source);
                        source = dest;
                    } else {
                        destMesh = this.createMesh(dest);
                    }
                    this.createStaticRotation(group, destMesh, background3D, source, this.transitionType == 5);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad 3D mode : " + this.transitionType);
                }
            }
            this.world.animate(0);
            this.startTime = System.currentTimeMillis();
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.cleanup();
        }
    }

    private void createFlyIn(Mesh destMesh, Background background3D) {
        background3D.setImage(this.createImage2D(this.getSource()));
        KeyframeSequence trans = new KeyframeSequence(10, 3, 176);
        KeyframeSequence alpha = new KeyframeSequence(2, 1, 176);
        alpha.setDuration(this.duration);
        trans.setDuration(this.duration);
        alpha.setKeyframe(0, 0, new float[]{0.1f});
        alpha.setKeyframe(1, this.duration, new float[]{1.0f});
        int frac = this.duration / 10;
        int time = 0;
        float position = -31.0f;
        for (int iter = 0; iter < 10; ++iter) {
            float[] pos = new float[]{0.0f, 0.0f, position};
            trans.setKeyframe(iter, time, pos);
            position += 3.0f;
            time += frac;
        }
        AnimationController animation = new AnimationController();
        AnimationTrack track = new AnimationTrack(trans, 275);
        destMesh.addAnimationTrack(track);
        track.setController(animation);
        track = new AnimationTrack(alpha, 256);
        destMesh.addAnimationTrack(track);
        track.setController(animation);
    }

    private void createCubeRotation(Group parent, Mesh destMesh, boolean vertical) {
        Group group = new Group();
        parent.addChild((Node)group);
        Mesh sourceMesh = this.createMesh(this.getSource());
        group.addChild((Node)destMesh);
        group.addChild((Node)sourceMesh);
        sourceMesh.setTranslation(0.0f, 0.0f, 1.0f);
        group.translate(0.0f, 0.0f, -4.7f);
        KeyframeSequence rotation = new KeyframeSequence(3, 4, 178);
        rotation.setDuration(this.duration);
        if (!vertical) {
            if (this.rotateRight) {
                destMesh.setOrientation(270.0f, 0.0f, 1.0f, 0.0f);
                destMesh.setTranslation(-1.0f, 0.0f, 0.0f);
            } else {
                destMesh.setOrientation(90.0f, 0.0f, 1.0f, 0.0f);
                destMesh.setTranslation(1.0f, 0.0f, 0.0f);
            }
            rotation.setKeyframe(0, 0, this.getYRoation(0.0f));
            if (this.rotateRight) {
                rotation.setKeyframe(1, this.duration / 2, this.getYRoation(20.0f));
                rotation.setKeyframe(2, this.duration, this.getYRoation(45.0f));
            } else {
                rotation.setKeyframe(1, this.duration / 2, this.getYRoation(-20.0f));
                rotation.setKeyframe(2, this.duration, this.getYRoation(-45.0f));
            }
        } else {
            if (this.rotateRight) {
                destMesh.setOrientation(270.0f, 1.0f, 0.0f, 0.0f);
                destMesh.setTranslation(0.0f, 1.0f, 0.0f);
            } else {
                destMesh.setOrientation(90.0f, 1.0f, 0.0f, 0.0f);
                destMesh.setTranslation(0.0f, -1.0f, 0.0f);
            }
            rotation.setKeyframe(0, 0, this.getXRoationTop(0.0f));
            if (this.rotateRight) {
                rotation.setKeyframe(1, this.duration / 2, this.getXRoationTop(20.0f));
                rotation.setKeyframe(2, this.duration, this.getXRoationTop(45.0f));
            } else {
                rotation.setKeyframe(1, this.duration / 2, this.getXRoationTop(-20.0f));
                rotation.setKeyframe(2, this.duration, this.getXRoationTop(-45.0f));
            }
        }
        AnimationController animation = new AnimationController();
        AnimationTrack track = new AnimationTrack(rotation, 268);
        group.addAnimationTrack(track);
        track.setController(animation);
    }

    private void createRotation(Group group, Mesh destMesh) {
        Mesh sourceMesh = this.createMesh(this.getSource());
        group.addChild((Node)sourceMesh);
        sourceMesh.setTranslation(0.0f, 0.0f, -3.79f);
        destMesh.setTranslation(0.0f, 0.0f, -3.8f);
        KeyframeSequence rotationSource = new KeyframeSequence(3, 4, 178);
        KeyframeSequence rotationDest = new KeyframeSequence(3, 4, 178);
        rotationSource.setDuration(this.duration);
        rotationDest.setDuration(this.duration);
        int half = 45;
        int full = 90;
        int halfDest = 150;
        int fullDest = 180;
        if (this.rotateRight) {
            half = -half;
            full = -full;
            halfDest = -halfDest;
            fullDest = -fullDest;
        }
        rotationSource.setKeyframe(0, 0, this.getYRoation(0.0f));
        rotationSource.setKeyframe(1, this.duration / 4, this.getYRoation(half));
        rotationSource.setKeyframe(2, this.duration / 2, this.getYRoation(full));
        rotationDest.setKeyframe(0, 0, this.getYRoation(full));
        rotationDest.setKeyframe(1, this.duration / 2, this.getYRoation(halfDest));
        rotationDest.setKeyframe(2, this.duration, this.getYRoation(fullDest));
        AnimationController animation = new AnimationController();
        AnimationTrack track = new AnimationTrack(rotationSource, 268);
        sourceMesh.addAnimationTrack(track);
        track.setController(animation);
        track = new AnimationTrack(rotationDest, 268);
        destMesh.addAnimationTrack(track);
        track.setController(animation);
    }

    private void createStaticRotation(Group group, Mesh destMesh, Background background3D, Component source, boolean swingIn) {
        Mesh rotatingNode;
        KeyframeSequence rotationDest;
        background3D.setImage(this.createImage2D(source));
        int halfDest = 90;
        int fullDest = 180;
        int mid = 135;
        AnimationController animation = new AnimationController();
        if (swingIn) {
            rotationDest = new KeyframeSequence(5, 4, 178);
            rotationDest.setDuration(this.duration);
            Group rotation = new Group();
            group.addChild((Node)rotation);
            rotation.addChild((Node)destMesh);
            if (this.rotateRight) {
                rotation.translate(0.0f, 0.8f, -4.0f);
                destMesh.translate(0.0f, -0.8f, 0.0f);
            } else {
                rotation.translate(0.0f, -0.8f, -4.0f);
                destMesh.translate(0.0f, 0.8f, 0.0f);
            }
            int quarter = this.duration / 4;
            if (source == this.getSource()) {
                rotationDest.setKeyframe(0, 0, this.getXRoationTop(halfDest));
                rotationDest.setKeyframe(1, quarter, this.getXRoationTop(mid));
                rotationDest.setKeyframe(2, quarter * 2, this.getXRoationTop(fullDest));
                rotationDest.setKeyframe(3, quarter * 3, this.getXRoationTop(fullDest + halfDest / 6));
                rotationDest.setKeyframe(4, this.duration, this.getXRoationTop(fullDest));
            } else {
                rotationDest.setKeyframe(0, 0, this.getXRoationTop(fullDest));
                rotationDest.setKeyframe(1, quarter, this.getXRoationTop(fullDest + halfDest / 6));
                rotationDest.setKeyframe(2, quarter * 2, this.getXRoationTop(fullDest));
                rotationDest.setKeyframe(3, quarter * 3, this.getXRoationTop(mid));
                rotationDest.setKeyframe(4, this.duration, this.getXRoationTop(halfDest));
            }
            rotatingNode = rotation;
        } else {
            if (this.rotateRight) {
                halfDest = -halfDest;
                fullDest = -fullDest;
                mid = -mid;
            }
            destMesh.setTranslation(0.0f, 0.0f, -3.8f);
            rotationDest = new KeyframeSequence(3, 4, 178);
            rotationDest.setDuration(this.duration);
            group.addChild((Node)destMesh);
            if (source == this.getSource()) {
                rotationDest.setKeyframe(0, 0, this.getYRoation(halfDest));
                rotationDest.setKeyframe(1, this.duration / 2, this.getYRoation(mid));
                rotationDest.setKeyframe(2, this.duration, this.getYRoation(fullDest));
            } else {
                rotationDest.setKeyframe(0, 0, this.getYRoation(fullDest));
                rotationDest.setKeyframe(1, this.duration / 2, this.getYRoation(mid));
                rotationDest.setKeyframe(2, this.duration, this.getYRoation(halfDest));
            }
            rotatingNode = destMesh;
        }
        AnimationTrack track = new AnimationTrack(rotationDest, 268);
        rotatingNode.addAnimationTrack(track);
        track.setController(animation);
    }

    private float[] getYRoation(float angle) {
        angle = (float)Math.toRadians(angle);
        return new float[]{0.0f, (float)Math.sin(angle), 0.0f, (float)Math.cos(angle)};
    }

    private float[] getXRoationTop(float angle) {
        angle = (float)Math.toRadians(angle);
        return new float[]{(float)Math.sin(angle), 0.0f, 0.0f, (float)Math.cos(angle)};
    }

    private Image2D createImage2D(Component c) {
        int textureH;
        int textureW;
        int w = c.getWidth();
        int h = c.getHeight();
        Dialog dlg = null;
        if (this.getSource() instanceof Dialog) {
            dlg = (Dialog)this.getSource();
            w = dlg.getContentPane().getWidth();
            h = dlg.getContentPane().getHeight() + dlg.getTitleComponent().getHeight();
        } else if (this.getDestination() instanceof Dialog) {
            dlg = (Dialog)this.getDestination();
            w = dlg.getContentPane().getWidth();
            h = dlg.getContentPane().getHeight() + dlg.getTitleComponent().getHeight();
        }
        if (this.highQualityMode) {
            int max = M3G.getInstance().getMaxTextureDimension();
            textureW = Math.min(M3G.closestHigherPowerOf2(w - 1), max);
            textureH = Math.min(M3G.closestHigherPowerOf2(h - 1), max);
        } else {
            textureW = Math.min(M3G.closestLowerPowerOf2(w + 1), maxTextureResolution);
            textureH = Math.min(M3G.closestLowerPowerOf2(h + 1), maxTextureResolution);
        }
        Image mutable = Image.createImage(w, h);
        Graphics g = mutable.getGraphics();
        if (c instanceof Dialog) {
            c = dlg.getContentPane();
            g.translate(-c.getAbsoluteX(), -c.getAbsoluteY() + dlg.getTitleComponent().getHeight());
            dlg.getContentPane().paintComponent(g, false);
            dlg.getTitleComponent().paintComponent(g, false);
        } else {
            if (dlg != null) {
                Container content = dlg.getContentPane();
                g.translate(-content.getAbsoluteX(), -content.getAbsoluteY() + dlg.getTitleComponent().getHeight());
            } else {
                g.translate(-c.getAbsoluteX(), -c.getAbsoluteY());
            }
            c.paintComponent(g);
        }
        mutable = mutable.scaled(textureW, textureH);
        return M3G.getInstance().createImage2D(99, mutable);
    }

    private Mesh createMesh(Component c) {
        Texture2D tex = this.createTexture(this.createImage2D(c));
        CompositingMode cm = new CompositingMode();
        cm.setBlending(64);
        cm.setAlphaWriteEnable(true);
        cm.setDepthTestEnable(true);
        Appearance appearance = new Appearance();
        PolygonMode polyMode = new PolygonMode();
        polyMode.setPerspectiveCorrectionEnable(true);
        appearance.setPolygonMode(polyMode);
        appearance.setCompositingMode(cm);
        appearance.setTexture(0, tex);
        VertexBuffer vb = this.makeGeometry();
        int[] indicies = new int[]{1, 2, 0, 3};
        int[] stripLens = new int[]{4};
        TriangleStripArray ib = new TriangleStripArray(indicies, stripLens);
        Mesh m = new Mesh(vb, (IndexBuffer)ib, appearance);
        return m;
    }

    private VertexBuffer makeGeometry() {
        short[] verts = new short[]{-1, -1, 0, 1, -1, 0, 1, 1, 0, -1, 1, 0};
        VertexArray va = new VertexArray(verts.length / 3, 3, 2);
        va.set(0, verts.length / 3, verts);
        short[] tcs = new short[]{0, 1, 1, 1, 1, 0, 0, 0};
        VertexArray texArray = new VertexArray(tcs.length / 2, 2, 2);
        texArray.set(0, tcs.length / 2, tcs);
        VertexBuffer vb = new VertexBuffer();
        vb.setPositions(va, 1.0f, null);
        vb.setTexCoords(0, texArray, 1.0f, null);
        return vb;
    }

    private Texture2D createTexture(Image2D img) {
        Texture2D tex = new Texture2D(img);
        tex.setFiltering(210, 210);
        tex.setWrapping(240, 240);
        tex.setBlending(228);
        return tex;
    }

    public void paintM3G(Graphics3D g) {
        g.render(this.world);
    }

    public boolean isHighQualityMode() {
        return this.highQualityMode;
    }

    public void setHighQualityMode(boolean highQualityMode) {
        this.highQualityMode = highQualityMode;
    }
}

