/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.html.CSSElement;
import com.sun.lwuit.html.CSSEngine;
import com.sun.lwuit.html.DocumentInfo;
import com.sun.lwuit.html.Element;
import com.sun.lwuit.html.ExtInputStreamReader;
import com.sun.lwuit.html.HTMLCallback;
import com.sun.lwuit.html.HTMLComponent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class Parser {
    private static final String[] COMMON_CHAR_ENTITIES = new String[]{"nbsp", "lt", "gt", "amp", "quot", "apos", "bull", "euro"};
    private static final int[] COMMON_CHAR_ENTITIES_VALS = new int[]{160, 60, 62, 38, 34, 39, 8226, 8364};
    static Parser instance;
    static String[] EMPTY_TAGS;
    private static final String[] CHAR_ENTITY_STRINGS;
    private static Hashtable USER_DEFINED_CHAR_ENTITIES;
    private static String[] SUPPORTED_MEDIA_TYPES;

    Parser() {
    }

    static Parser getInstance() {
        if (instance == null) {
            instance = new Parser();
        }
        return instance;
    }

    static void setCSSSupportedMediaTypes(String[] supportedMediaTypes) {
        SUPPORTED_MEDIA_TYPES = supportedMediaTypes;
    }

    static int getStringVal(String str, String[] options) {
        return Parser.getStringVal(str, options, null, -1);
    }

    static int getStringVal(String str, String[] options, int[] vals) {
        return Parser.getStringVal(str, options, vals, -1);
    }

    static int getStringVal(String str, String[] options, int defaultValue) {
        return Parser.getStringVal(str, options, null, defaultValue);
    }

    static int getStringVal(String str, String[] options, int[] vals, int defaultValue) {
        if (str != null) {
            for (int i = 0; i < options.length; ++i) {
                if (!str.equalsIgnoreCase(options[i])) continue;
                if (vals != null) {
                    return vals[i];
                }
                return i;
            }
        }
        return defaultValue;
    }

    static void addCharEntity(String symbol, int code) {
        if (USER_DEFINED_CHAR_ENTITIES == null) {
            USER_DEFINED_CHAR_ENTITIES = new Hashtable();
        }
        USER_DEFINED_CHAR_ENTITIES.put(Parser.trimCharEntity(symbol), new Integer(code));
    }

    static void addCharEntitiesRange(String[] symbols, int startcode) {
        if (USER_DEFINED_CHAR_ENTITIES == null) {
            USER_DEFINED_CHAR_ENTITIES = new Hashtable();
        }
        for (int i = 0; i < symbols.length; ++i) {
            if (symbols[i] == null) continue;
            USER_DEFINED_CHAR_ENTITIES.put(Parser.trimCharEntity(symbols[i]), new Integer(startcode + i));
        }
    }

    private static String trimCharEntity(String symbol) {
        if (symbol.startsWith("&")) {
            symbol = symbol.substring(1);
        }
        if (symbol.endsWith(";")) {
            symbol = symbol.substring(0, symbol.length() - 1);
        }
        return symbol;
    }

    private static int getCharEntityCode(String symbol) {
        Object charObj;
        int val = Parser.getStringVal(symbol, COMMON_CHAR_ENTITIES, COMMON_CHAR_ENTITIES_VALS);
        if (val != -1) {
            return val;
        }
        val = Parser.getStringVal(symbol, CHAR_ENTITY_STRINGS);
        if (val != -1) {
            return val + 161;
        }
        if (USER_DEFINED_CHAR_ENTITIES != null && (charObj = USER_DEFINED_CHAR_ENTITIES.get(symbol)) != null) {
            return (Integer)charObj;
        }
        return -1;
    }

    private String convertCharEntity(String charEntity, HTMLCallback callback) {
        int charCode = -1;
        if (charEntity.startsWith("#")) {
            if (charEntity.startsWith("#x")) {
                try {
                    charCode = Integer.parseInt(charEntity.substring(2), 16);
                }
                catch (NumberFormatException nfe) {}
            } else {
                try {
                    charCode = Integer.parseInt(charEntity.substring(1));
                }
                catch (NumberFormatException nfe) {}
            }
        } else {
            charCode = Parser.getCharEntityCode(charEntity);
        }
        if (charCode != -1) {
            return "" + (char)charCode;
        }
        Parser.notifyError(callback, 4, null, null, null, "Unrecognized char entity: " + charEntity);
        return "&" + charEntity + ";";
    }

    Element parse(InputStreamReader is, HTMLComponent htmlC) {
        Element rootElement = new Element("ROOT");
        try {
            this.parseTagContent(rootElement, is, htmlC);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return rootElement;
    }

    private void parseTagContent(Element element, InputStreamReader is, HTMLComponent htmlC) throws IOException {
        HTMLCallback callback = htmlC.getHTMLCallback();
        if (htmlC.loadCSS && element.getId() == 54) {
            CSSElement addTo = this.parseCSSSegment(is, null, htmlC, null);
            htmlC.addToEmebeddedCSS(addTo);
            return;
        }
        String text = null;
        boolean leadingSpace = false;
        char c = (char)is.read();
        String charEntity = null;
        while ((byte)c != -1) {
            if (c == '<') {
                Element childElement;
                if (text != null) {
                    if (charEntity != null) {
                        text = text + "&" + charEntity;
                        charEntity = null;
                    }
                    if (leadingSpace) {
                        text = " " + text;
                    }
                    Element textElement = new Element("text");
                    textElement.addAttribute("title", text);
                    element.addChild(textElement);
                    text = null;
                    leadingSpace = false;
                }
                if ((childElement = this.parseTag(is, htmlC)) == null) {
                    String closingTag = "";
                    c = (char)is.read();
                    while (c != '>') {
                        closingTag = closingTag + c;
                        c = (char)is.read();
                    }
                    if (closingTag.equalsIgnoreCase(element.getName())) {
                        return;
                    }
                    if (!this.isEmptyTag(closingTag)) {
                        Parser.notifyError(callback, 3, element.getName(), null, null, "Malformed HTML - no appropriate closing tag for " + element.getName());
                    }
                } else if (childElement.getId() != -1) {
                    element.addChild(childElement);
                }
            } else if (text != null) {
                if (charEntity != null) {
                    if (c == ';') {
                        text = text + this.convertCharEntity(charEntity, callback);
                        charEntity = null;
                    } else {
                        charEntity = charEntity + c;
                    }
                } else if (c == '&') {
                    charEntity = "";
                } else {
                    text = text + c;
                }
            } else if (!Parser.isWhiteSpace(c)) {
                if (c == '&') {
                    charEntity = "";
                    text = "";
                } else {
                    text = "" + c;
                }
            } else if (c == ' ') {
                leadingSpace = true;
            }
            c = (char)is.read();
        }
    }

    static boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    private Element parseTag(InputStreamReader is, HTMLComponent htmlC) throws IOException {
        Element element;
        String tagName = "";
        String curAttribute = "";
        String curValue = "";
        boolean procInst = false;
        HTMLCallback callback = htmlC.getHTMLCallback();
        char c = (char)is.read();
        if (c == '/') {
            return null;
        }
        if (c == '!') {
            c = (char)is.read();
            char c2 = (char)is.read();
            if (c == '-' && c2 == '-') {
                return this.parseCommentOrXMLDeclaration(is, "-->");
            }
            return this.parseCommentOrXMLDeclaration(is, ">");
        }
        if (c == '?') {
            procInst = true;
            c = (char)is.read();
        }
        while (Parser.isWhiteSpace(c)) {
            c = (char)is.read();
        }
        while (!Parser.isWhiteSpace(c) && c != '>' && c != '/') {
            tagName = tagName + c;
            c = (char)is.read();
        }
        while (Parser.isWhiteSpace(c)) {
            c = (char)is.read();
        }
        tagName = tagName.toLowerCase();
        if (procInst) {
            if (tagName.equals("xml-stylesheet")) {
                tagName = "link";
            } else {
                c = (char)is.read();
                while (c != '>') {
                    c = (char)is.read();
                }
                return new Element("unsupported");
            }
        }
        if ((element = new Element(tagName)).getId() == -1) {
            Parser.notifyError(callback, 0, tagName, null, null, "The tag '" + tagName + "' is not supported in XHTML-MP 1.0");
            char lastChar = c;
            while (c != '>') {
                lastChar = c;
                c = (char)is.read();
            }
            if (lastChar != '/') {
                String endTag = "</" + tagName + ">";
                int index = 0;
                while (index < endTag.length()) {
                    c = (char)is.read();
                    if (c >= 'A' && c <= 'Z') {
                        c = (char)(c - 65 + 97);
                    }
                    if (c == endTag.charAt(index)) {
                        ++index;
                        continue;
                    }
                    index = 0;
                }
            }
            return element;
        }
        if (c == '>') {
            if (!this.isEmptyTag(tagName)) {
                this.parseTagContent(element, is, htmlC);
            }
            return element;
        }
        if (c == '/' || procInst && c == '?') {
            c = (char)is.read();
            if (c == '>') {
                return element;
            }
            Parser.notifyError(callback, 6, tagName, null, null, "HTML malformed - no > after /");
        }
        while (true) {
            int error;
            curAttribute = "" + c;
            c = (char)is.read();
            while (!Parser.isWhiteSpace(c) && c != '=' && c != '>') {
                curAttribute = curAttribute + c;
                c = (char)is.read();
            }
            if (c == '>') {
                Parser.notifyError(callback, 5, tagName, curAttribute, null, "Unexpected tag closing in tag " + tagName + ", attribute=" + curAttribute);
                if (!this.isEmptyTag(tagName)) {
                    this.parseTagContent(element, is, htmlC);
                }
                return element;
            }
            while (Parser.isWhiteSpace(c)) {
                c = (char)is.read();
            }
            if (c != '=') {
                Parser.notifyError(callback, 6, tagName, curAttribute, null, "Unexpected character " + c + ", expected '=' after attribute " + curAttribute + " in tag " + tagName);
                if (c != '>') continue;
                if (!this.isEmptyTag(tagName)) {
                    this.parseTagContent(element, is, htmlC);
                }
                return element;
            }
            c = (char)is.read();
            while (Parser.isWhiteSpace(c)) {
                c = (char)is.read();
            }
            char quote = ' ';
            if (c == '\"' || c == '\'') {
                quote = c;
            } else {
                curValue = curValue + c;
            }
            String charEntity = null;
            boolean ended = false;
            while (!ended) {
                c = (char)is.read();
                if (c == quote) {
                    ended = true;
                    c = (char)is.read();
                    continue;
                }
                if (quote == ' ' && (c == '/' || c == '>' || Parser.isWhiteSpace(c))) {
                    ended = true;
                    continue;
                }
                if (c == '&') {
                    if (charEntity != null) {
                        curValue = curValue + "&" + charEntity;
                    }
                    charEntity = "";
                    continue;
                }
                if (charEntity != null) {
                    if (c == ';') {
                        curValue = curValue + this.convertCharEntity(charEntity, callback);
                        charEntity = null;
                        continue;
                    }
                    charEntity = charEntity + c;
                    continue;
                }
                curValue = curValue + c;
            }
            if (charEntity != null) {
                curValue = curValue + "&" + charEntity;
                charEntity = null;
            }
            if ((error = element.addAttribute(curAttribute = curAttribute.toLowerCase(), curValue)) == 1) {
                Parser.notifyError(callback, error, tagName, curAttribute, curValue, "Attribute '" + curAttribute + "' is not supported for tag '" + tagName + "'. Supported attributes: " + element.getSupportedAttributesList());
            } else if (error == 2) {
                Parser.notifyError(callback, error, tagName, curAttribute, curValue, "Attribute '" + curAttribute + "' in tag '" + tagName + "' has an invalid value (" + curValue + ")");
            }
            while (Parser.isWhiteSpace(c)) {
                c = (char)is.read();
            }
            if (c == '>') {
                if (!this.isEmptyTag(tagName)) {
                    this.parseTagContent(element, is, htmlC);
                }
                return element;
            }
            if (c == '/' || procInst && c == '?') {
                c = (char)is.read();
                if (c == '>') {
                    return element;
                }
                Parser.notifyError(callback, 6, tagName, curAttribute, curValue, "HTML malformed - no > after /");
            }
            curAttribute = "";
            curValue = "";
        }
    }

    private Element parseCommentOrXMLDeclaration(InputStreamReader is, String endTag) throws IOException {
        int endTagPos = 0;
        String text = "";
        boolean ended = false;
        while (!ended) {
            char c = (char)is.read();
            if (c == endTag.charAt(endTagPos)) {
                if (++endTagPos != endTag.length()) continue;
                ended = true;
                continue;
            }
            if (endTagPos != 0) {
                text = text + endTag.substring(0, endTagPos);
                endTagPos = 0;
            }
            text = text + c;
        }
        String elementName = null;
        if (endTag.equals("-->")) {
            elementName = "comment";
        } else if (endTag.equals(">")) {
            elementName = "XML declaration";
        }
        Element comment = new Element(elementName);
        comment.addAttribute("content", text);
        return comment;
    }

    private boolean isEmptyTag(String tagName) {
        boolean found = false;
        for (int i = 0; i < EMPTY_TAGS.length && !found; ++i) {
            if (!tagName.equals(EMPTY_TAGS[i])) continue;
            found = true;
        }
        return found;
    }

    private static void notifyError(HTMLCallback callback, int errorId, String tag, String attribute, String value, String description) {
        boolean cont;
        if (callback != null && !(cont = callback.parsingError(errorId, tag, attribute, value, description))) {
            throw new IllegalArgumentException(description);
        }
    }

    private char handleCSSComment(ExtInputStreamReader r) throws IOException {
        char c = r.readCharFromReader();
        if (c == '*') {
            char lastC = '\u0000';
            while (c != '/' || lastC != '*') {
                lastC = c;
                c = r.readCharFromReader();
            }
            c = r.readCharFromReader();
            while ((byte)c != -1 && Parser.isWhiteSpace(c)) {
                c = r.readCharFromReader();
            }
        } else {
            r.unreadChar(c);
            return '/';
        }
        return c;
    }

    private String nextToken(ExtInputStreamReader r, boolean readNewline, boolean ignoreCommas, boolean ignoreColons, boolean ignoreWhiteSpaces) throws IOException {
        boolean newline = false;
        StringBuffer currentToken = new StringBuffer();
        char c = r.readCharFromReader();
        while ((byte)c != -1 && Parser.isWhiteSpace(c)) {
            boolean bl = newline = newline || c == '\n' || c == '\r' || c == ';' || c == ',' && !ignoreCommas;
            if (!readNewline && newline) {
                return null;
            }
            c = r.readCharFromReader();
        }
        if (c == ';' && readNewline) {
            c = r.readCharFromReader();
            while ((byte)c != -1 && Parser.isWhiteSpace(c)) {
                newline = newline || c == '\n' || c == '\r' || c == ';' || c == ',' && !ignoreCommas;
                c = r.readCharFromReader();
            }
        }
        char segment = '\u0000';
        while (!((byte)c == -1 || Parser.isWhiteSpace(c) && segment == '\u0000' && !ignoreWhiteSpaces || c == ';' || c == ':' && segment == '\u0000' && !ignoreColons || c == ',' && segment == '\u0000' && !ignoreCommas || c == '>')) {
            if (segment == '\u0000' && c == '/') {
                c = this.handleCSSComment(r);
            }
            if ((c == '}' || c == '{' || c == '*') && segment == '\u0000') {
                newline = true;
                if (currentToken.length() == 0) {
                    if (!readNewline) {
                        r.unreadChar(c);
                        return null;
                    }
                    return "" + c;
                }
                r.unreadChar(c);
                break;
            }
            currentToken.append(c);
            if (c == '(') {
                segment = ')';
            } else if (segment == '\u0000' && (c == '\"' || c == '\'')) {
                segment = c;
            } else if (c == segment) {
                segment = '\u0000';
            }
            c = r.readCharFromReader();
        }
        if (c == ',' && !ignoreCommas) {
            currentToken.append(c);
        }
        if (!readNewline && c == ';' && currentToken.length() != 0) {
            r.unreadChar(c);
        }
        if (currentToken.length() == 0) {
            return null;
        }
        return currentToken.toString();
    }

    private void copyAttributes(CSSElement element, Vector selectors, Element addTo) {
        if (selectors == null) {
            return;
        }
        Enumeration e = selectors.elements();
        while (e.hasMoreElements()) {
            CSSElement selector = (CSSElement)e.nextElement();
            addTo.addChild(selector);
            while (selector.getNumChildren() > 0) {
                selector = selector.getCSSChildAt(0);
            }
            element.copyAttributesTo(selector);
        }
    }

    private boolean isMediaTypeSupported(String media) {
        for (int i = 0; i < SUPPORTED_MEDIA_TYPES.length; ++i) {
            if (!media.equalsIgnoreCase(SUPPORTED_MEDIA_TYPES[i])) continue;
            return true;
        }
        return false;
    }

    boolean mediaTypeMatches(String mediaTypes) {
        if (mediaTypes == null || mediaTypes.equals("")) {
            return true;
        }
        int comma = mediaTypes.indexOf(44);
        while (comma != -1) {
            if (this.isMediaTypeSupported(mediaTypes.substring(0, comma).trim())) {
                return true;
            }
            mediaTypes = mediaTypes.substring(comma + 1);
            comma = mediaTypes.indexOf(44);
        }
        return this.isMediaTypeSupported(mediaTypes.trim());
    }

    private String getImportURLByMediaType(String token) {
        String url = token;
        boolean mediaMatches = true;
        int space = token.indexOf(32);
        if (space != -1) {
            url = token.substring(0, space);
            token = token.substring(space + 1);
            mediaMatches = this.mediaTypeMatches(token);
        }
        if (mediaMatches) {
            if (url.startsWith("url(")) {
                url = CSSEngine.getCSSUrl(url);
            }
            return url;
        }
        return null;
    }

    private ExtInputStreamReader getMediaSegment(ExtInputStreamReader r, String encoding, HTMLComponent htmlC) throws IOException {
        String token = this.nextToken(r, true, true, true, true);
        char c = r.readCharFromReader();
        while ((byte)c != -1 && c != '{') {
            c = r.readCharFromReader();
        }
        StringBuffer segment = new StringBuffer();
        boolean match = this.mediaTypeMatches(token);
        int count = 1;
        while (count > 0 && (byte)(c = r.readCharFromReader()) != -1) {
            if (match) {
                segment.append(c);
            }
            if (c == '{') {
                ++count;
                continue;
            }
            if (c != '}') continue;
            --count;
        }
        if (match) {
            ExtInputStreamReader segmentReader = null;
            if (encoding != null) {
                try {
                    segmentReader = new ExtInputStreamReader(new InputStreamReader((InputStream)new ByteArrayInputStream(segment.toString().getBytes()), encoding));
                }
                catch (UnsupportedEncodingException uee) {
                    Parser.notifyError(htmlC.getHTMLCallback(), 9, "@media", null, encoding, "Encoding '" + encoding + "' failed for media segment. " + uee.getMessage());
                }
            }
            if (segmentReader == null) {
                segmentReader = new ExtInputStreamReader(new InputStreamReader(new ByteArrayInputStream(segment.toString().getBytes())));
            }
            return segmentReader;
        }
        return null;
    }

    CSSElement parseCSSSegment(InputStreamReader isr, InputStream is, HTMLComponent htmlC, String pageURL) throws IOException {
        CSSElement addTo = new CSSElement("style");
        ExtInputStreamReader r = new ExtInputStreamReader(isr);
        DocumentInfo docInfo = null;
        String encoding = htmlC.getDocumentInfo() != null ? htmlC.getDocumentInfo().getEncoding() : null;
        String token = this.nextToken(r, true, false, true, false);
        while (token.startsWith("@")) {
            if (token.equals("@import")) {
                token = this.nextToken(r, true, true, true, true);
                String url = this.getImportURLByMediaType(token);
                if (url != null) {
                    if (docInfo == null) {
                        DocumentInfo documentInfo = docInfo = pageURL == null ? htmlC.getDocumentInfo() : new DocumentInfo(pageURL);
                    }
                    if (docInfo != null) {
                        htmlC.getThreadQueue().addCSS(docInfo.convertURL(url), encoding);
                    } else if (DocumentInfo.isAbsoluteURL(url)) {
                        htmlC.getThreadQueue().addCSS(url, encoding);
                    } else {
                        Parser.notifyError(htmlC.getHTMLCallback(), 14, "@import", null, url, "Ignoring CSS file referred in an @import rule (" + url + "), since page was set by setBody/setHTML so there's no way to access relative URLs");
                    }
                }
            } else if (token.equals("@media")) {
                ExtInputStreamReader mediaReader = this.getMediaSegment(r, encoding, htmlC);
                if (mediaReader != null) {
                    this.parseCSS(mediaReader, htmlC, addTo, null);
                }
            } else if (token.equals("@charset")) {
                token = CSSEngine.omitQuotesIfExist(this.nextToken(r, true, false, true, false));
                if (is != null) {
                    try {
                        ExtInputStreamReader encodedReader;
                        r = encodedReader = new ExtInputStreamReader(new InputStreamReader(is, token));
                        encoding = token;
                    }
                    catch (UnsupportedEncodingException uee) {
                        Parser.notifyError(htmlC.getHTMLCallback(), 9, "@charset", null, token, "External CSS encoding @charset " + token + " directive failed: " + uee.getMessage());
                    }
                }
            }
            token = this.nextToken(r, true, false, true, false);
        }
        return this.parseCSS(r, htmlC, addTo, token);
    }

    CSSElement parseCSS(InputStreamReader r, HTMLComponent htmlC) throws IOException {
        ExtInputStreamReader er = new ExtInputStreamReader(r);
        return this.parseCSS(er, htmlC, null, null);
    }

    /*
     * Unable to fully structure code
     */
    CSSElement parseCSS(ExtInputStreamReader r, HTMLComponent htmlC, CSSElement addTo, String firstToken) throws IOException {
        if (addTo == null) {
            addTo = new CSSElement("style");
        }
        parent = addTo;
        selectors = new Vector<CSSElement>();
        lastGroupedParent = null;
        selectorMode = true;
        grouping = false;
        token = "";
        block0: while (true) {
            if (firstToken != null) {
                token = firstToken;
                firstToken = null;
            } else {
                token = this.nextToken(r, true, false, selectorMode, false);
            }
            if (token == null || token.indexOf("</style") > -1) break;
            if ("{".equals(token)) {
                selectorMode = false;
                grouping = false;
                continue;
            }
            if ("}".equals(token)) {
                selectorMode = true;
                this.copyAttributes(parent, selectors, addTo);
                parent = addTo;
                selectors = new Vector<E>();
                lastGroupedParent = null;
                continue;
            }
            if (",".equals(token) && selectorMode) {
                grouping = true;
                continue;
            }
            if (selectorMode) {
                if (token.startsWith(",")) {
                    token = token.substring(1);
                    grouping = true;
                }
                if (grouping) {
                    if (token.endsWith(",")) {
                        token = token.substring(0, token.length() - 1);
                    } else {
                        grouping = false;
                    }
                    entry = new CSSElement(token);
                    selectors.addElement(entry);
                    lastGroupedParent = entry;
                    continue;
                }
                if (token.endsWith(",")) {
                    grouping = true;
                    token = token.substring(0, token.length() - 1);
                }
                entry = new CSSElement(token);
                if (lastGroupedParent == null) {
                    parent.addChild(entry);
                    parent = entry;
                    continue;
                }
                lastGroupedParent.addChild(entry);
                lastGroupedParent = entry;
                continue;
            }
            compoundToken = false;
            for (iter = 0; iter < CSSElement.CSS_SHORTHAND_ATTRIBUTE_LIST.length; ++iter) {
                if (!CSSElement.CSS_SHORTHAND_ATTRIBUTE_LIST[iter].equals(token)) continue;
                compoundToken = true;
                collattable = CSSElement.CSS_IS_SHORTHAND_ATTRIBUTE_COLLATABLE[iter];
                valsAdded = 0;
                token = this.nextToken(r, false, false, false, false);
                tokens = new String[4];
                while (token != null) {
                    if (collattable) {
                        if (valsAdded < tokens.length) {
                            tokens[valsAdded] = token;
                            ++valsAdded;
                        }
                    } else {
                        this.addShorthandAttribute(token, iter, parent);
                    }
                    token = this.nextToken(r, false, false, false, false);
                }
                if (!collattable || valsAdded <= 0) break;
                for (i = 0; i < CSSElement.CSS_COLLATABLE_ORDER[valsAdded - 1].length; ++i) {
                    for (j = 0; j < CSSElement.CSS_COLLATABLE_ORDER[valsAdded - 1][i].length; ++j) {
                        side = CSSElement.CSS_COLLATABLE_ORDER[valsAdded - 1][i][j];
                        this.addAttributeTo(parent, CSSElement.CSS_SHORTHAND_ATTRIBUTE_INDEX[iter][side], tokens[i], htmlC);
                    }
                }
                break;
            }
            if (compoundToken || (result = this.addAttributeTo(parent, token, this.nextToken(r, false, true, false, token.equalsIgnoreCase("-wap-access-key") != false || token.equalsIgnoreCase("font-family") != false), htmlC)) == -1) continue;
            while (true) {
                if (this.nextToken(r, false, false, false, false) != null) ** break;
                continue block0;
            }
            break;
        }
        return addTo;
    }

    private boolean addShorthandAttribute(String value, int shorthandAttr, CSSElement selector) {
        if (CSSElement.CSS_IS_SHORTHAND_ATTRIBUTE_COLLATABLE[shorthandAttr]) {
            return this.addCollatableAttribute(value, shorthandAttr, selector);
        }
        for (int i = 0; i < CSSElement.CSS_SHORTHAND_ATTRIBUTE_INDEX[shorthandAttr].length; ++i) {
            boolean success;
            int result;
            int attrIndex = CSSElement.CSS_SHORTHAND_ATTRIBUTE_INDEX[shorthandAttr][i];
            if (!(attrIndex >= 500 ? !selector.isAttributeAssigned(attrIndex) && (result = selector.addAttribute(attrIndex, value)) == -1 : (success = this.addShorthandAttribute(value, attrIndex, selector)))) continue;
            return true;
        }
        return false;
    }

    private boolean addCollatableAttribute(String value, int shorthandAttr, CSSElement selector) {
        int attrIndex = CSSElement.CSS_SHORTHAND_ATTRIBUTE_INDEX[shorthandAttr][0];
        int result = selector.addAttribute(attrIndex, value);
        if (result == -1) {
            for (int i = 1; i < CSSElement.CSS_SHORTHAND_ATTRIBUTE_INDEX[shorthandAttr].length; ++i) {
                attrIndex = CSSElement.CSS_SHORTHAND_ATTRIBUTE_INDEX[shorthandAttr][i];
                selector.addAttribute(attrIndex, value);
            }
            return true;
        }
        return false;
    }

    private int addAttributeTo(CSSElement selector, int attrId, String value, HTMLComponent htmlC) {
        int error = selector.addAttribute(attrId, value);
        this.reportAddAttributeError(error, selector, selector.getAttributeName(new Integer(attrId)), value, htmlC);
        return error;
    }

    private int addAttributeTo(CSSElement selector, String attributeName, String value, HTMLComponent htmlC) {
        int error = selector.addAttribute(attributeName, value);
        this.reportAddAttributeError(error, selector, attributeName, value, htmlC);
        return error;
    }

    private void reportAddAttributeError(int errorCode, CSSElement selector, String attributeName, String value, HTMLComponent htmlC) {
        if (errorCode != -1) {
            if (errorCode == 11) {
                Parser.notifyError(htmlC.getHTMLCallback(), errorCode, selector.getName(), attributeName, value, "CSS Attribute '" + attributeName + "' (Appeared in selector '" + selector.getName() + "') is not supported in WCSS.");
            } else if (errorCode == 12) {
                Parser.notifyError(htmlC.getHTMLCallback(), errorCode, selector.getName(), attributeName, value, "CSS Attribute '" + attributeName + "' (Appeared in selector '" + selector.getName() + "') has an invalid value (" + value + ")");
            }
        }
    }

    static {
        EMPTY_TAGS = new String[]{"br", "link", "meta", "base", "area", "basefont", "col", "frame", "hr", "img", "input", "isindex", "param"};
        CHAR_ENTITY_STRINGS = new String[]{"iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};
        SUPPORTED_MEDIA_TYPES = new String[]{"all", "handheld"};
    }
}

