/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.Component;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.html.HTMLLink;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;

class CSSBorder
extends Border {
    Border[] borders = new Border[4];
    Component cmp;

    static CSSBorder createCSSBorder(Border[] borders, Component cmp) {
        boolean allnull = true;
        for (int i = 0; i < borders.length; ++i) {
            if (borders[i] == null) continue;
            allnull = false;
            break;
        }
        if (allnull) {
            return null;
        }
        return new CSSBorder(borders, cmp);
    }

    void mergeBorder(Border[] newBorders) {
        for (int i = 0; i < newBorders.length; ++i) {
            if (newBorders[i] == null) continue;
            this.borders[i] = newBorders[i];
        }
    }

    CSSBorder(Border[] borders, Component ui) {
        this.borders = borders;
        this.cmp = ui;
    }

    public void paint(Graphics g, Component c) {
        Rectangle clip;
        int x = c.getX();
        int y = c.getY();
        int width = c.getWidth();
        int height = c.getHeight();
        Style style = c.getStyle();
        boolean drawLeft = true;
        boolean drawRight = true;
        if (c instanceof HTMLLink) {
            HTMLLink link = (HTMLLink)c;
            HTMLLink parentLink = link.parentLink;
            if (parentLink == null) {
                if (link.childLinks != null) {
                    drawRight = false;
                }
            } else {
                drawLeft = false;
                if (parentLink.childLinks.lastElement() != link) {
                    drawRight = false;
                }
            }
        }
        if (UIManager.getInstance().getLookAndFeel().isRTL()) {
            boolean temp = drawLeft;
            drawLeft = drawRight;
            drawRight = temp;
        }
        if (this.borders[0] != null) {
            clip = this.saveClip(g);
            g.clipRect(x, y, width, style.getPadding(0));
            this.borders[0].paint(g, c);
            this.restoreClip(g, clip);
        }
        if (this.borders[2] != null) {
            clip = this.saveClip(g);
            g.clipRect(x, y + height - style.getPadding(2), width, style.getPadding(2));
            this.borders[2].paint(g, c);
            this.restoreClip(g, clip);
        }
        if (drawLeft && this.borders[1] != null) {
            clip = this.saveClip(g);
            g.clipRect(x, y + style.getPadding(0), style.getPadding(1), height - style.getPadding(0) - style.getPadding(2));
            this.borders[1].paint(g, c);
            this.restoreClip(g, clip);
        }
        if (drawRight && this.borders[3] != null) {
            clip = this.saveClip(g);
            g.clipRect(x + width - style.getPadding(3), y + style.getPadding(0), style.getPadding(3), height - style.getPadding(0) - style.getPadding(2));
            this.borders[3].paint(g, c);
            this.restoreClip(g, clip);
        }
    }

    private Rectangle saveClip(Graphics g) {
        return new Rectangle(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
    }

    private void restoreClip(Graphics g, Rectangle rect) {
        g.setClip(rect.getX(), rect.getY(), rect.getSize().getWidth(), rect.getSize().getHeight());
    }

    public void paintBorderBackground(Graphics g, Component c) {
    }
}

