<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN"
  "http://www.w3.org/tr/xhtml11/Dtd/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="pl">
<head>
  <meta http-equiv="Content-type" content="text/html; charset=utf-8" />
  <title>Prosta księga gości działająca w oparciu na pliku tekstowym</title>
</head>
<body>
  <div>
    <?php
       // Skrypt realizuje zapis informacji w księdze gości w pliku 
       // tekstowym.

      if(isSet($_POST['osoba']) && isSet($_POST['wpis'])){
        $osoba = nl2br(htmlspecialchars ($_POST['osoba']));
        $wpis = nl2br(htmlspecialchars ($_POST['wpis']));
      }
      else{
        $osoba = '';
        $wpis = '';
      }

      if ($osoba && $wpis) { // są informacje do wpisania do księgi gości

        // skomplikowany wpis do księgi gości
        $ksiega[0] = "<dl><dt>".$wpis."</dt><dd><b>".$osoba.",</b> <i>".
                      date("d.m.Y")."</i></dd></dl>\r\n";

        if (file_exists("dane/ksiegagosci.txt")) { // już jest założona 
          $i = 1;
          $plik = fopen ("dane/ksiegagosci.txt", "r+"); // odczyt danych
          flock ($plik, 2);
          while (!(feof($plik))) {
            $ksiega[$i++] = fgets ($plik, 2048);
          }
          fseek ($plik, 0);          // powrót do początku pliku
          for ($j=0; $j<$i; $j++) {  // i zapis
            fputs ($plik, "$ksiega[$j]");
          }
          flock ($plik, 3);
          fclose ($plik);
        } else {                     // nie ma pliku, więc tworzysz nowy
          $plik = fopen ("dane/ksiegagosci.txt", "w+");
          flock ($plik, 2);
          fputs ($plik, "$ksiega[0]");
          flock ($plik, 3);
          fclose ($plik);
        }
      } 

      // jeżeli jest już księga, trzeba ją wypisać, niezależnie od tego,
      // czy jest nowy wpis.
      if (file_exists("dane/ksiegagosci.txt")) { 
        $plik = fopen ("dane/ksiegagosci.txt", "r");
        while (!(feof($plik))) {
          print (fgets ($plik, 2048));
        }
        print "<hr />";
      }
    ?>
    <!-- Na dole jest formularz z możliwością dopisania się do księgi-->
    <form method="post" action="6-07.php"><div>
      <table>
        <tr><td>Osoba:</td><td><input type="text" name="osoba" /></td></tr>
        <tr><td>Wpis:</td><td>
           <textarea name="wpis" cols="45" rows="4"></textarea>
        </td></tr>
      </table>
      <input type="submit" value="wyślij" />
    </div></form>
  </div>
</body>
</html>
