# -*- coding: utf-8 -*-
from django.contrib import admin

from news.models import *

class CategoryAdmin(admin.ModelAdmin):
	list_display = ('name','icon')
	prepopulated_fields = {'slug': ('name',)}

class NewsAdmin(admin.ModelAdmin):
	list_display = ('title','date')
	prepopulated_fields = {'slug': ('title',)}

class CommentAdmin(admin.ModelAdmin):
	list_display = ('news','text', 'date')
	list_filter = ('date',)

admin.site.register(Comment, CommentAdmin)
admin.site.register(Category, CategoryAdmin)
admin.site.register(News, NewsAdmin)
