# -*- coding: utf-8 -*-
from datetime import datetime

from django.template import RequestContext
from django.shortcuts import render_to_response
from django.views.generic.list_detail import object_list
from django import forms
from django.http import HttpResponse, HttpResponseRedirect
from django.conf import settings

from reportlab.platypus import Table, TableStyle, Paragraph
from reportlab.lib import colors
from reportlab.pdfgen import canvas
from reportlab.lib.pagesizes import A4
from reportlab.pdfbase import pdfmetrics
from reportlab.pdfbase.ttfonts import TTFont
from reportlab.lib.styles import getSampleStyleSheet

from news.models import *

def index(request):
	news = News.objects.all().order_by('-id')
	return object_list(
		request,
		news,
		paginate_by = 10,
		extra_context = {},
		template_name = 'index.html')

def news_by_category(request, slug):
	c = Category.objects.get(slug=slug)
	#news = News.objects.filter(category=c).order_by('-id')
	news = c.news_set.all()
	return object_list(
		request,
		news,
		paginate_by = 10,
		extra_context = {'c':c},
		template_name = 'news_by_category.html')

class AddCommentForm(forms.ModelForm):
	class Meta:
		model = Comment

def show_news(request, slug):
	try:
		news = News.objects.get(slug=slug)
	except:
		return render_to_response('error.html',
			{'error': 'Strona nie istnieje'},
			context_instance=RequestContext(request))
	if request.POST:
		data = request.POST.copy()
		data['news'] = news.id
		data['date'] = datetime.now()
		form = AddCommentForm(data)
		if form.is_valid():
			form.save()
	form = AddCommentForm()
	return render_to_response('show_news.html', {'news': news, 'form':form}, context_instance=RequestContext(request))


def show_news_pdf(request, slug):
	try:
		news = News.objects.get(slug=slug)
	except:
		return render_to_response('error.html',
			{'error': 'Strona nie istnieje'},
			context_instance=RequestContext(request))
	e = HttpResponse()
	e['Content-Type'] = 'application/pdf'
	e['Content-Disposition'] = 'attachment; filename="%s.pdf";' % news.slug
	
	c = canvas.Canvas(e, pagesize=A4)
	
	width, height = A4
	pdfmetrics.registerFont(TTFont('Dejavu', settings.APP_ROOT + 'site_media/fonts/DejaVuSans.ttf'))
	c.setFont("Dejavu", 14)
	c.drawString(50,(height-60), news.title)
	
	stylesheet=getSampleStyleSheet()
	styleN = stylesheet['Normal']
	styleN.fontName = 'Dejavu'
	styleN.fontSize = 9
	
	p = Paragraph(news.text, styleN)
	w,h = p.wrap(width-70, height)
	p.drawOn(c, 50, (height-120))
	
	c.line(50, (70), 570, (70))
	c.setFont("Dejavu", 8)
	c.drawString(50,(60), unicode(news.date))
	c.drawString(50,(50), u'Wiadomość ze strony http://www.MOJASTRONA.pl')
	
	c.showPage()
	c.save()
	return e

def ajax(request):
	return HttpResponse(unicode(datetime.now()))