﻿namespace BeehiveManagementSystem;

abstract class Bee
{
    /// <summary>
    /// Ilość jednostek miodu zużywana przez daną pszczołę w każdej zmianie.
    /// </summary>
    public abstract decimal CostPerShift { get; }

    /// <summary>
    /// Funkcja przydzielona danej pszczole.
    /// </summary>
    public string Job { get; private set; }

    /// <summary>
    /// Konstruktor klasy Bee.
    /// </summary>
    /// <param name="job">Funkcja przydzielona danej pszczole</param>
    public Bee(string job)
    {
        Job = job;
    }

    /// <summary>
    /// Jeśli ilość miodu jest wystarczająca, aby dana pszczoła przepracowała następną zmianę, należy zużyć 
    /// odpowiednią ilość miodu.
    /// </summary>
    /// <returns>True, jeśli ilość miodu wystarczya do wykonania pracy; w przeciwnym razie false</returns>
    public virtual bool WorkTheNextShift()
    {
        if (HoneyVault.ConsumeHoney(CostPerShift))
            return true;
        else
            return false;
    }
}
