﻿int numberOfBalls = ReadInt(20, "Liczba kulek");
int magazineSize = ReadInt(16, "Pojemność magazynka");

Console.Write($"Załadowany [false]: ");
bool.TryParse(Console.ReadLine(), out bool isLoaded);

PaintballGun gun = new PaintballGun(numberOfBalls, magazineSize, isLoaded);
while (true)
{
    Console.WriteLine($"Liczba kulek: {gun.Balls}, załadowano: {gun.BallsLoaded} ");
    if (gun.IsEmpty()) Console.WriteLine("UWAGA: brak amunicji");
    Console.WriteLine("Spacja - strzał, r - przeładowanie, " +
                  "+ - dodanie amunicji, q - koniec");
    char key = Console.ReadKey(true).KeyChar;
    if (key == ' ') Console.WriteLine($"Strzał: {gun.Shoot()}");
    else if (key == 'r') gun.Reload();
    else if (key == '+') gun.Balls += gun.MagazineSize;
    else if (key == 'q') return;
}

static int ReadInt(int defaultValue, string prompt)
{
    Console.Write(prompt + " [" + defaultValue + "]: ");
    string? line = Console.ReadLine();
    if (int.TryParse(line, out int value))
    {
        Console.WriteLine("   użycie wartości " + value);
        return value;
    }
    else
    {
        Console.WriteLine("   użycie wartości domyślnej " + defaultValue);
        return defaultValue;
    }
}
