﻿using Serilog;

Log.Logger = new LoggerConfiguration()
    .WriteTo.Console()
    .WriteTo.File($"log-{DateTime.Now:yyyyMMdd-HHmmss}.log")
    .CreateLogger();

Log.Information("Liczba argumentów w wywołaniu aplikacji: {0}; argumenty: {1}",
                args.Length, args);

var firstLine = "Nie wczytano pierwszego wiersza";
try
{
    var lines = File.ReadAllLines(args[0]);
    firstLine = (lines.Length > 0) ? lines[0] : "Plik był pusty";
    if (lines.Length == 0) Log.Warning("W pliku nie znaleziono tekstu");
}
catch (IndexOutOfRangeException)
{
    Log.Warning("Podaj nazwę pliku.");
}
catch (FileNotFoundException)
{
    Log.Error("Nie można znaleźć pliku: {0}", args[0]);
}
catch (UnauthorizedAccessException ex)
{
    Log.Error(ex, "Nie można uzyskać dostępu do pliku {0}", args[0], ex.Message);
}
finally
{
    Console.WriteLine(firstLine);
}
