﻿static class HiLoGame
{
    public const int MAXIMUM = 10;
    private static int currentNumber = Random.Shared.Next(1, MAXIMUM + 1);
    private static int nextNumber = Random.Shared.Next(1, MAXIMUM + 1);
    private static int pot = 10;

    public static int GetPot() { return pot; }

    public static void Guess(bool higher)
    {
        if ((higher && nextNumber >= currentNumber) ||
               (!higher && nextNumber <= currentNumber))
        {
            Console.WriteLine("Zgadłeś!");
            pot++;
        }
        else
        {
            Console.WriteLine("Niestety, błędna odpowiedź.");
            pot--;
        }
        currentNumber = nextNumber;
        nextNumber = Random.Shared.Next(1, MAXIMUM + 1);
        Console.WriteLine($"Aktualna wartość to {currentNumber}");
    }

    public static void Hint()
    {
        int half = MAXIMUM / 2;
        if (nextNumber >= half)
          Console.WriteLine($"Bieżąca liczba to {currentNumber}, " +
                      $"następna liczba wynosi co najmniej {half}");
          else Console.WriteLine($"Bieżąca liczba to {currentNumber}, " +
                      $"następna liczba jest mniejsza niż {half}");
        pot--;
    }
}