﻿using System.ComponentModel;

namespace AddDataBinding;

class Moods : INotifyPropertyChanged
{
    public string CurrentMood { get; private set; } = "Jestem szczęśliwy!";

    public event PropertyChangedEventHandler? PropertyChanged;

    protected void OnPropertyChanged(string name)
    {
        PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(name));
    }

    public void UpdateMood()
    {
        switch (Random.Shared.Next(1, 4))
        {
            case 1:
                CurrentMood = "Jestem szczęśliwy!";
                break;
            case 2:
                CurrentMood = "Ale mi smutno.";
                break;
            default:
                CurrentMood = "Czuję się nieźle.";
                break;
        }

        SemanticScreenReader.Announce(CurrentMood);

        OnPropertyChanged("CurrentMood");
    }
}
