﻿List<Duck> ducks = [
    new Duck(43, KindOfDuck.krzyżówka),
    new Duck(45, KindOfDuck.piżmowa),
    new Duck(35, KindOfDuck.nur),
    new Duck(27, KindOfDuck.piżmowa),
    new Duck(35, KindOfDuck.krzyżówka),
    new Duck(33, KindOfDuck.nur),

];

ducks.Sort();
PrintDucks(ducks);

IComparer<Duck> sizeComparer = new DuckComparerBySize();
ducks.Sort(sizeComparer);
PrintDucks(ducks);

IComparer<Duck> kindComparer = new DuckComparerByKind();
ducks.Sort(kindComparer);
PrintDucks(ducks);

DuckComparer comparer = new DuckComparer();
Console.WriteLine("\nSortowanie według gatunku, potem według wielkości\n");
comparer.SortBy = SortCriteria.KindThenSize;
ducks.Sort(comparer);
PrintDucks(ducks);
Console.WriteLine("\nSortowanie według wielkości, potem według gatunku\n");
comparer.SortBy = SortCriteria.SizeThenKind;
ducks.Sort(comparer);
PrintDucks(ducks);

void PrintDucks(List<Duck> ducks)
{
    foreach (Duck duck in ducks)
    {
        Console.WriteLine(duck);
    }
}
