﻿using System;

namespace SharpenYourPencil
{
    using System.Linq;

    class Program
    {
        static string Output(Suits suit, int number) =>
            $"Kolor to {suit}, a wartość karty to {number}.";

        static void Main(string[] args)
        {
            var deck = new Deck();
            var processedCards = deck
                .Take(3)
                .Concat(deck.TakeLast(3))
                .OrderByDescending(card => card)
                .Select(card => card.Value switch
                {
                    Values.Król => Output(card.Suit, 7),
                    Values.As => $"To as! {card.Suit}",
                    Values.Walet => Output((Suits)card.Suit - 1, 9),
                    Values.Dwójka => Output(card.Suit, 18),
                    _ => card.ToString(),
                });

            foreach (var output in processedCards)
            {
                Console.WriteLine(output);
            }
        }
    }
}
