﻿using System;
namespace GoFishTests
{
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using System.Collections.Generic;
    using GoFish;
    using System.Linq;

    [TestClass]
    public class GameControllerTests
    {
        [TestInitialize]
        public void Initialize()
        {
            Player.Random = new MockRandom() { ValueToReturn = 0 };
        }


        [TestMethod]
        public void TestConstructor()
        {
            var gameController = new GameController("Człowiek",
                            new List<string>() { "Gracz1", "Gracz2", "Gracz3" });
            Assert.AreEqual("Rozpoczynanie nowej gry z graczami Człowiek, Gracz1, Gracz2, Gracz3",
                            gameController.Status);
        }

        [TestMethod]
        public void TestNextRound()
        {
            // Konstruktor tasuje talię, ale klasa MacokRandom gwarantuje, że kolejność
            // zostaje zachowana. Tak więc Oskar powinien mieć kara od asa do 5, a Basia kara od 6 do 10.
            var gameController = new GameController("Oskar", new List<string>() { "Basia" });

            gameController.NextRound(gameController.Opponents.First(), Values.Szóstka);
            Assert.AreEqual("Oskar prosi gracza Basia o kartę Szóstka" +
             Environment.NewLine + "Basia - liczba kart Szóstka to 1" +
             Environment.NewLine + "Basia prosi gracza Oskar o kartę Siódemka" +
             Environment.NewLine + "Basia dobrał(a) kartę" +
             Environment.NewLine + "Oskar - liczba kart: 6; wyłożone zestawy: 0" +
             Environment.NewLine + "Basia - liczba kart: 5; wyłożone zestawy: 0" +
             Environment.NewLine + "Liczba kart na kupce: 41" +
             Environment.NewLine, gameController.Status);
        }

        [TestMethod]
        public void TestNewGame()
        {
            Player.Random = new MockRandom() { ValueToReturn = 0 };
            var gameController = new GameController("Oskar", new List<string>() { "Basia" });
            gameController.NextRound(gameController.Opponents.First(), Values.Szóstka);
            gameController.NewGame();
            Assert.AreEqual("Oskar", gameController.HumanPlayer.Name);
            Assert.AreEqual("Basia", gameController.Opponents.First().Name);
            Assert.AreEqual("Rozpoczęcie nowej gry", gameController.Status);
        }
    }
}
