﻿using System;

namespace UseAFinallyBlock
{
    using System.IO;

    class Program
    {
        static void Main(string[] args)
        {
            var firstLine = "Nie wczytano pierwszego wiersza";
            try
            {
                var lines = File.ReadAllLines(args[0]);
                firstLine = (lines.Length > 0) ? lines[0] : "Plik był pusty";
            }
            catch (IndexOutOfRangeException)
            {
                Console.Error.WriteLine("Podaj nazwę pliku.");
            }
            catch (FileNotFoundException)
            {
                Console.Error.WriteLine("Nie można znaleźć pliku: {0}", args[0]);
            }
            catch (UnauthorizedAccessException ex)
            {
                Console.Error.WriteLine("Plik {0} jest niedostępny: {1}",
                                        args[0], ex.Message);
            }
            finally
            {
                Console.WriteLine(firstLine);
            }
        }

    }
}
