using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace GoFishTests
{
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using System.Collections.Generic;
    using System.Linq;
    using GoFish;

    [TestClass]
    public class PlayerTests
    {
        [TestMethod]
        public void TestGetNextHand()
        {
            var player = new Player("Oskar", new List<Card>());
            player.GetNextHand(new Deck());
            CollectionAssert.AreEqual(
                new Deck().Take(5).Select(card => card.ToString()).ToList(),
                player.Hand.Select(card => card.ToString()).ToList());
        }

        [TestMethod]
        public void TestDoYouHaveAny()
        {
            IEnumerable<Card> cards = new List<Card>()
        {
            new Card(Values.Walet, Suits.pik),
            new Card(Values.Trójka, Suits.trefl),
            new Card(Values.Trójka, Suits.kier),
            new Card(Values.Czwórka, Suits.karo),
            new Card(Values.Trójka, Suits.karo),
            new Card(Values.Walet, Suits.trefl),
        };

            var player = new Player("Oskar", cards);


            var threes = player.DoYouHaveAny(Values.Trójka, new Deck())
                .Select(Card => Card.ToString())
                .ToList();

            CollectionAssert.AreEqual(new List<string>()
        {
            "Trójka karo",
            "Trójka trefl",
            "Trójka kier",
        }, threes);

            Assert.AreEqual(3, player.Hand.Count());

            var jacks = player.DoYouHaveAny(Values.Walet, new Deck())
                .Select(Card => Card.ToString())
                .ToList();

            CollectionAssert.AreEqual(new List<string>()
        {
            "Walet trefl",
            "Walet pik",
        }, jacks);

            var hand = player.Hand.Select(Card => Card.ToString()).ToList();
            CollectionAssert.AreEqual(new List<string>() { "Czwórka karo" }, hand);

            Assert.AreEqual("Oskar - liczba kart: 1; wyłożone zestawy: 0", player.Status);
        }

        [TestMethod]
        public void TestAddCardsAndPullOutBooks()
        {
            IEnumerable<Card> cards = new List<Card>()
        {
            new Card(Values.Walet, Suits.pik),
            new Card(Values.Trójka, Suits.trefl),
            new Card(Values.Walet, Suits.kier),
            new Card(Values.Trójka, Suits.kier),
            new Card(Values.Czwórka, Suits.karo),
            new Card(Values.Walet, Suits.karo),
            new Card(Values.Walet, Suits.trefl),
        };

            var player = new Player("Oskar", cards);

            Assert.AreEqual(0, player.Books.Count());

            var cardsToAdd = new List<Card>()
        {
            new Card(Values.Trójka, Suits.karo),
            new Card(Values.Trójka, Suits.pik),
        };
            player.AddCardsAndPullOutBooks(cardsToAdd);

            var books = player.Books.ToList();
            CollectionAssert.AreEqual(new List<Values>() { Values.Trójka, Values.Walet}, books);

            var hand = player.Hand.Select(Card => Card.ToString()).ToList();
            CollectionAssert.AreEqual(new List<string>() { "Czwórka karo" }, hand);

            Assert.AreEqual("Oskar - liczba kart: 1; wyłożone zestawy: 2", player.Status);
        }

        [TestMethod]
        public void TestDrawCard()
        {
            var player = new Player("Oskar", new List<Card>());
            player.DrawCard(new Deck());
            Assert.AreEqual(1, player.Hand.Count());
            Assert.AreEqual("As karo", player.Hand.First().ToString());
        }

        [TestMethod]
        public void TestRandomValueFromHand()
        {
            var player = new Player("Oskar", new Deck());

            Player.Random = new MockRandom() { ValueToReturn = 0 };
            Assert.AreEqual("As", player.RandomValueFromHand().ToString());
            Player.Random = new MockRandom() { ValueToReturn = 4 };
            Assert.AreEqual("Dwójka", player.RandomValueFromHand().ToString());
            Player.Random = new MockRandom() { ValueToReturn = 8 };
            Assert.AreEqual("Trójka", player.RandomValueFromHand().ToString());
        }
    }

}
