﻿using System;
using System.Collections.Generic;
using System.Text;

namespace WeaponDamage_Part_1
{
    class ArrowDamage
    {
        private const decimal BASE_MULTIPLIER = 0.35M;
        private const decimal MAGIC_MULTIPLIER = 2.5M;
        private const decimal FLAME_DAMAGE = 1.25M;

        /// <summary>
        /// Zawiera obliczone obrażenia.
        /// </summary>
        public int Damage { get; private set; }

        private int roll;

        /// <summary>
        /// Ustawia lub pobiera wartość rzutu 3d6.
        /// </summary>
        public int Roll
        {
            get { return roll; }
            set
            {
                roll = value;
                CalculateDamage();
            }
        }

        private bool magic;

        /// <summary>
        /// Zwraca true, jeśli strzały są magiczne; w przeciwnym razie zwraca false.
        /// </summary>
        public bool Magic
        {
            get { return magic; }
            set
            {
                magic = value;
                CalculateDamage();
            }
        }

        private bool flaming;

        /// <summary>
        /// Zwraca true, jeśli strzały są płonące; w przeciwnym razie zwraca false.
        /// </summary>
        public bool Flaming
        {
            get { return flaming; }
            set
            {
                flaming = value;
                CalculateDamage();
            }
        }
        /// <summary>
        /// Oblicza uszkodzenia na podstawie aktualnych wartości właściwości.
        /// </summary>
        private void CalculateDamage()
        {
            decimal baseDamage = Roll * BASE_MULTIPLIER;
            if (Magic) baseDamage *= MAGIC_MULTIPLIER;
            if (Flaming) Damage = (int)Math.Ceiling(baseDamage + FLAME_DAMAGE);
            else Damage = (int)Math.Ceiling(baseDamage);
        }

        /// <summary>
        /// Konstruktor oblicza obrażenia na podstawie domyślnych wartości właściwości 
        /// Magic i Flaming oraz początkowego rzutu 3d6.
        /// </summary>
        /// <param name="startingRoll">Początkowy rzut 3d6</param>
        public ArrowDamage(int startingRoll)
        {
            roll = startingRoll;
            CalculateDamage();
        }
    }
}
