﻿using System;
using System.Collections;
using System.Collections.Generic;

namespace Chapter11
{
    class CompoundEqualityComparerDemo
    {
        static void Main()
        {
            var comparer = new CompoundEqualityComparer();
            comparer.Add(new AbsoluteValueEqualityComparer());
            comparer.Add(StringComparer.OrdinalIgnoreCase);

            IStructuralEquatable a = ("abc", 10, 'x');
            IStructuralEquatable b = ("ABC", 10, 'x');
            IStructuralEquatable c = ("abc", -10, 'x');
            IStructuralEquatable d = ("abc", 10, 'X');
            IStructuralEquatable e = ("def", 10, 'x');
            IStructuralEquatable f = ("abc", 20, 'x');
            IStructuralEquatable g = ("abc", 10, 'y');

            Console.WriteLine(a.Equals(b, comparer)); // True: w porównaniach łańcuchów znaków wielkość liter jest nieistotna
            Console.WriteLine(a.Equals(c, comparer)); // True: w porównaniach wartości typu int znak nie ma znaczenia
            Console.WriteLine(a.Equals(d, comparer)); // False: w porównaniach wartości typu char wielkość znaków jest istotna
            Console.WriteLine(a.Equals(e, comparer)); // False: wartość typu string nie jest ignorowana
            Console.WriteLine(a.Equals(f, comparer)); // False: wartość typu int nie jest ignorowana
            Console.WriteLine(a.Equals(g, comparer)); // False: wartość typu char nie jest ignorowana
        }

        private class AbsoluteValueEqualityComparer : IEqualityComparer<int>
        {
            // Nasza implementacja metody GetHashCode nie zwraca true
            // dla obiektów, które różnią się od siebie.
            public bool Equals(int x, int y) => GetHashCode(x) == GetHashCode(y);

            // Kod nie zwraca wartości bezwzględnej, tylko *ujemną* wartość bezwzględną, ponieważ
            // umożliwia to łatwą obsługę wartości int.MinValue.
            public int GetHashCode(int obj) => obj > 0 ? -obj : obj;
        }
    }
}
