﻿using System;
using System.ComponentModel;
using System.Threading.Tasks;

namespace Chapter05
{
    [Description("Listing 5.6c (metoda lokalna)")]
    class EagerArgumentValidation3
    {
        static void Main()
        {
            MainAsync().GetAwaiter().GetResult();
        }

        // Ta metoda jest taka sama jak w klasie LazyArgumentValidation;
        // inna jest tylko metoda ComputeLengthAsync.
        static async Task MainAsync()
        {
            Task<int> task = ComputeLengthAsync(null);
            Console.WriteLine("Pobrano zadanie");
            int length = await task;
            Console.WriteLine("Długość: {0}", length);
        }

        static Task<int> ComputeLengthAsync(string text)
        {
            if (text == null)
            {
                // Jeśli można użyć metody lokalnej, z pewnością można też zastosować nameof...
                throw new ArgumentNullException(nameof(text));
            }
            return Impl(text);

            // Mogłaby to być metoda bezparametrowa, jednak przekazanie wartości zamiast
            // przechwytywania jej pozwala kompilatorowi na dodatkowe optymalizacje.
            async Task<int> Impl(string t)
            {
                await Task.Delay(500);
                return t.Length;
            }
        }
    }
}
