﻿using System;
using System.ComponentModel;
using System.Threading.Tasks;

namespace Chapter05
{
    [Description("Listing 5.6a (osobna metoda z implementacją)")]
    class EagerArgumentValidation1
    {
        static void Main()
        {
            MainAsync().GetAwaiter().GetResult();
        }

        // Ta metoda jest taka sama jak w klasie LazyArgumentValidation;
        // inna jest tylko metoda ComputeLengthAsync.
        static async Task MainAsync()
        {
            Task<int> task = ComputeLengthAsync(null);
            Console.WriteLine("Pobrano zadanie");
            int length = await task;
            Console.WriteLine("Długość: {0}", length);
        }

        static Task<int> ComputeLengthAsync(string text)
        {
            if (text == null)
            {
                throw new ArgumentNullException("tekst");
            }
            return ComputeLengthAsyncImpl(text);
        }

        static async Task<int> ComputeLengthAsyncImpl(string text)
        {
            await Task.Delay(500);
            return text.Length;
        }
    }
}
