﻿#pragma warning disable CS0219 // Do zmiennej przypisywana jest wartość, która jednak nigdy nie jest używana.
using System;
using System.ComponentModel;

namespace Chapter02
{
    // Zauważ, że używana jest nazwa CatpuredVariablesDemoImpl zamiast CapturedVariablesImpl.
    [Description("Listing 3.7")]
    class CapturedVariablesDemoImpl
    {
        private string instanceField = "pole instancji";

        private class LambdaContext
        {
            public CapturedVariablesDemoImpl originalThis;
            public string methodParameter;
            public string methodLocal;

            public void Method(string lambdaParameter)
            {
                string lambdaLocal = "zmienna lokalna wyrażenia lambda";
                Console.WriteLine("Pole instancji: {0}", originalThis.instanceField);
                Console.WriteLine("Parametr metody: {0}", methodParameter);
                Console.WriteLine("Zmienna lokalna metody: {0}", methodLocal);
                Console.WriteLine("Parametr wyrażenia lambda: {0}", lambdaParameter);
                Console.WriteLine("Zmienna lokalna wyrażenia lambda: {0}", lambdaLocal);
            }
        }

        public Action<string> CreateAction(string methodParameter)
        {
            LambdaContext context = new LambdaContext();
            context.originalThis = this;
            context.methodParameter = methodParameter;
            context.methodLocal = "zmienna lokalna metody";
            string uncaptured = "nieprzechwytywana zmienna lokalna";

            Action<string> action = context.Method;
            context.methodLocal = "zmodyfikowana zmienna lokalna metody";
            return action;
        }

        static void Main()
        {
            var demo = new CapturedVariablesDemoImpl();
            Action<string> action = demo.CreateAction("argument metody");
            action("argument wyrażenia lambda");
        }
    }
}
