﻿#pragma warning disable CS0219 // Do zmiennej przypisywana jest wartość, która jednak nigdy nie jest używana.
using System;
using System.ComponentModel;

namespace Chapter02
{
    [Description("Listing 3.6")]
    class CapturedVariablesDemo
    {
        private string instanceField = "pole instancji";

        public Action<string> CreateAction(string methodParameter)
        {
            string methodLocal = "metoda lokalna";
            string uncaptured = "nieprzechwytywana zmienna lokalna";

            Action<string> action = lambdaParameter =>
            {
                string lambdaLocal = "zmienna lokalna wyrażenia lambda";
                Console.WriteLine("Pole instancji: {0}", instanceField);
                Console.WriteLine("Parametr metody: {0}", methodParameter);
                Console.WriteLine("Zmienna lokalna metody: {0}", methodLocal);
                Console.WriteLine("Parametr wyrażenia lambda: {0}", lambdaParameter);
                Console.WriteLine("Zmienna lokalna wyrażenia lambda: {0}", lambdaLocal);
            };
            return action;
        }

        static void Main()
        {
            var demo = new CapturedVariablesDemo();
            Action<string> action = demo.CreateAction("argument metody");
            action("argument wyrażenia lambda");
        }
    }
}
