﻿using System;
using System.ComponentModel;
using static System.Math;

namespace Chapter15
{
    [Description("Listing 15.11")]
    class PropertyPatterns1
    {
        static void Main()
        {
            Rectangle r = new Rectangle(10, 5);
            Triangle t = new Triangle(3, 4, 5);
            Circle c = new Circle(10);
            Console.WriteLine($"Obwód prostokąta: {Perimeter(r)}");
            Console.WriteLine($"Obwód trójkąta: {Perimeter(t)}");
            Console.WriteLine($"Obwód okręgu: {Perimeter(c)}");
        }

        static double Perimeter(Shape shape) => shape switch
        {
            null => throw new ArgumentNullException(nameof(shape)),
            Rectangle { Height: var h, Width: var w } => 2 * (h + w),
            Circle { Radius: var radius } => 2 * PI * radius,
            Triangle { SideA: var a, SideB: var b, SideC: var c } => a + b + c,
            _ => throw new ArgumentException(
                $"Nieznany obwód figury typu {shape.GetType()}", nameof(shape))
        };
    }
}
