﻿using System;
using System.ComponentModel;
using System.Threading.Tasks;

namespace Chapter15
{
    [Description("Listing 15.16")]
    class AsyncDisposal
    {
        class AsyncResource : IAsyncDisposable
        {
            public async Task DisposeAsync()
            {
                Console.WriteLine("Asynchroniczne zwalnianie zasobów...");
                await Task.Delay(2000);
                Console.WriteLine("...gotowe");
            }

            public async Task PerformWorkAsync()
            {
                Console.WriteLine("Asynchroniczne wykonywanie pracy...");
                await Task.Delay(2000);
                Console.WriteLine("...gotowe");
            }
        }

        async static Task Main()
        {
            using await (var resource = new AsyncResource())
            {
                await resource.PerformWorkAsync();
            }
            Console.WriteLine("Po instrukcji using await");
        }
    }
}
