﻿using System;
using System.ComponentModel;
using System.Threading.Tasks;

namespace Chapter05
{
    [Description("Listing 5.3")]
    class UnsafeCodeInAsyncMethod
    {
        static void Main()
        {
            DelayWithResultOfUnsafeCode("Jakiś tekst").GetAwaiter().GetResult();
        }

        static async Task DelayWithResultOfUnsafeCode(string text)
        {
            int total = 0;
            unsafe
            {
                fixed (char* textPointer = text)
                {
                    char* p = textPointer;
                    while (*p != 0)
                    {
                        total += *p;
                        p++;
                    }
                }
            }
            Console.WriteLine("Zatrzymanie na " + total + " ms");
            await Task.Delay(total);
            Console.WriteLine("Po zatrzymaniu");
        }
    }
}
