﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Chapter04
{
    class MixedDynamicAndStaticOverloadResolution
    {
        static void Method(int x, string y)
        {
            Console.WriteLine("int, string");
        }

        static void Method(int x, object y)
        {
            Console.WriteLine("int, object");
        }

        static void Method(object x, object y)
        {
            Console.WriteLine("object, object");
        }

        static void Main()
        {
            dynamic arg1 = 10;
            object arg2 = "text";
            // Wywoływana jest druga wersja - "int, object".
            // - Pierwsza nie jest wybierana, ponieważ używany jest typ argumentu arg2 *z czasu kompilacji*.
            //   Choć jest to wywołanie wiązane dynamicznie, dla drugiego argumentu używany jest
            //   typ statyczny "object", dlatego to on jest używany w czasie wyboru wersji metody.
            // - Trzecia wersja nie jest wybierana, ponieważ druga jest bardziej specyficzna:
            //   używany jest typ argumentu arg1 z czasu wykonywania programu, ponieważ arg1 to zmienna dynamiczna.
            Method(arg1, arg2);
        }
    }
}
