﻿using System;
using System.ComponentModel;
using System.Threading.Tasks;

namespace Chapter05
{
    [Description("Listing 5.6b (anonimowa funkcja asynchroniczna)")]
    class EagerArgumentValidation2
    {
        static void Main()
        {
            MainAsync().GetAwaiter().GetResult();
        }

         // Ta metoda jest taka sama jak w klasie LazyArgumentValidation;
        // inna jest tylko metoda ComputeLengthAsync.
        static async Task MainAsync()
        {
            Task<int> task = ComputeLengthAsync(null);
            Console.WriteLine("Pobrano zadanie");
            int length = await task;
            Console.WriteLine("Długość: {0}", length);
        }

        static Task<int> ComputeLengthAsync(string text)
        {
            if (text == null)
            {
                throw new ArgumentNullException("text");
            }
            // Można byłoby użyć typu Func<Task<int>> i tekstu,
            // to jednak byłoby mniej wydajne niż
            // bezpośrednie przekazywanie wartości.
            Func<string, Task<int>> impl = async t =>
            {
                await Task.Delay(500);
                return text.Length;
            };
            return impl(text);
        }
    }
}
