﻿using System;
using System.ComponentModel;
using System.Threading.Tasks;

namespace Chapter06
{
    [Description("Listing 6.9")]
    class AwaitInsideTryFinally
    {
        static async Task AwaitInTryFinally(TimeSpan delay)
        {
            Console.WriteLine("Przed blokiem try");
            try
            {
                Console.WriteLine("Przed wyrażeniem await");
                await Task.Delay(delay);
                Console.WriteLine("Po wyrażeniu await");
            }
            finally
            {
                Console.WriteLine("W bloku finally");
            }
            Console.WriteLine("Po bloku finally");
        }

        static void Main()
        {
            AwaitInTryFinally(TimeSpan.FromSeconds(1)).Wait();
        }
    }
}
