﻿using System;
using System.Diagnostics.Contracts;

namespace Chapter15
{
    class ContractInheritance
    {
        [Pure]
        static bool Report(string text)
        {
            Console.WriteLine(text);
            return true;
        }

        class Base
        {
            [ContractInvariantMethod]
            private void BaseInvariant()
            {
                Contract.Invariant(Report("BaseInvariant"));
            }

            public virtual void VirtualMethod(string text)
            {
                Contract.Requires(Report("Warunek wstępny klasy bazowej"));
                Contract.Ensures(Report("Warunek końcowy klasy bazowej"));
            }
        }

        class Derived : Base
        {
            [ContractInvariantMethod]
            private void DerivedInvariant()
            {
                Contract.Invariant(Report("Inwariant klasy potomnej"));
            }

            public override void VirtualMethod(string text)
            {
                Contract.Ensures(Report("Warunek końcowy klasy potomnej"));
            }
        }

        class DerivedWithNoInvariant : Base
        {
            public void BaseInvariantWillStillBeCalled()
            {                
            }
        }

        static void Main()
        {
            Base d = new Derived();
            Console.WriteLine("Konstruktor wykonany");
            d.VirtualMethod("");
        }
    }
}
