﻿using System;
using System.ComponentModel;

namespace Chapter04
{
    [Description("Listing 4.1")]
    class NullableMembers
    {
        static void Display(Nullable<int> x)
        {
            Console.WriteLine("HasValue: {0}", x.HasValue);
            if (x.HasValue)
            {
                Console.WriteLine("Value: {0}", x.Value);
                Console.WriteLine("Jawna konwersja: {0}", (int)x);
            }
            Console.WriteLine("GetValueOrDefault(): {0}",
                               x.GetValueOrDefault());
            Console.WriteLine("GetValueOrDefault(10): {0}",
                               x.GetValueOrDefault(10));
            Console.WriteLine("ToString(): \"{0}\"", x.ToString());
            Console.WriteLine("GetHashCode(): {0}", x.GetHashCode());
            Console.WriteLine();
        }

        static void Main()
        {
            Nullable<int> x = 5;
            x = new Nullable<int>(5);
            Console.WriteLine("Instancja z wartością:");
            Display(x);

            x = new Nullable<int>();
            Console.WriteLine("Instancja bez wartości:");
            Display(x);
        }
    }
}
