﻿using System;
using System.ComponentModel;
using System.Linq;
using System.Xml.Linq;

namespace Chapter01
{
    [Description("Listing 1.17")]
    class LinqToXml
    {
        static void Main()
        {
            XDocument doc = XDocument.Load("dane.xml");
            var filtered = from p in doc.Descendants("Product")
                           join s in doc.Descendants("Supplier")
                           on (int)p.Attribute("SupplierID")
                               equals (int)s.Attribute("SupplierID")
                           where (decimal)p.Attribute("Price") > 10
                           orderby (string)s.Attribute("Name"),
                                   (string)p.Attribute("Name")
                           select new
                           {
                               SupplierName = (string)s.Attribute("Name"),
                               ProductName = (string)p.Attribute("Name")
                           };
            foreach (var v in filtered)
            {
                Console.WriteLine("Dostawca={0}; Produkt={1}",
                                  v.SupplierName, v.ProductName);
            }
        }
    }
}
