﻿using System;
using System.Collections.Generic;
using System.ComponentModel;

namespace Chapter09
{
    [Description("Listing 9.04")]
    class FilmFilteringAndSorting
    {
        class Film
        {
            public string Name { get; set; }
            public int Year { get; set; }
        }

        static void Main()
        {
            var films = new List<Film>
            {
                new Film {Name="Szczęki", Year=1975},
                new Film {Name="Deszczowa piosenka", Year=1952},
                new Film {Name="Pół żartem, pół serio", Year=1959},
                new Film {Name="Czarnoksiężnik z Oz", Year=1939},
                new Film {Name="To wspaniałe życie", Year=1946},
                new Film {Name="American Beauty", Year=1999},
                new Film {Name="Przeboje i podboje", Year=2000},
                new Film {Name="Podejrzani", Year=1995}
            };

            Action<Film> print = 
                film => Console.WriteLine("Tytuł={0}, Rok={1}", film.Name, film.Year);

            // Note: extra lines added for clarity when running
            Console.WriteLine("Wszystkie filmy");
            films.ForEach(print);                                
            Console.WriteLine();

            Console.WriteLine("Stare");
            films.FindAll(film => film.Year < 1960)              
                 .ForEach(print);
            Console.WriteLine();

            Console.WriteLine("Posortowane");
            films.Sort((f1, f2) => f1.Name.CompareTo(f2.Name));  
            films.ForEach(print);                                
        }        
    }
}
