﻿using System;
using System.Collections.Generic;
using System.ComponentModel;

namespace Chapter05
{
    [Description("Listing 5.05")]
    class SimpleAnonymousMethods
    {
        static void Main()
        {
            Action<string> printReverse = delegate(string text)
            {
                char[] chars = text.ToCharArray();
                Array.Reverse(chars);
                Console.WriteLine(new string(chars));
            };

            Action<int> printRoot = delegate(int number)
            {
                Console.WriteLine(Math.Sqrt(number));
            };

            Action<IList<double>> printMean = delegate(IList<double> numbers)
            {
                double total = 0;
                foreach (double value in numbers)
                {
                    total += value;
                }
                Console.WriteLine(total / numbers.Count);
            };

            printReverse("Witaj świecie!");
            printRoot(2);
            printMean(new double[] { 1.5, 2.5, 3, 4.5 });
        }
    }
}
