﻿using System.Collections.Generic;
using System.ComponentModel;

namespace Chapter01.CSharp2
{
    [Description("Listing 1.02")]
    public class Product
    {
        string name;
        public string Name
        {
            get { return name; }
            private set { name = value; }
        }

        decimal price;
        public decimal Price
        {
            get { return price; }
            private set { price = value; }
        }

        public Product(string name, decimal price)
        {
            Name = name;
            Price = price;
        }

        public static List<Product> GetSampleProducts()
        {
            List<Product> list = new List<Product>();
            list.Add(new Product("Ogniem i mieczem", 9.99m));
            list.Add(new Product("Potop", 14.99m));
            list.Add(new Product("Krzyżacy", 13.99m));
            list.Add(new Product("Faraon", 10.99m));
            return list;
        }

        public override string ToString()
        {
            return string.Format("{0}: {1}", name, price);
        }
    }
}