using System;
using System.Web.Services;
using System.Drawing;
using System.IO;
using System.Net;
// Access Web Service to Return Images
// compile: csc /r:imgproxy.dll imgclient.cs
public class ImageClient
{
	static void Main(string[] args)
	{
		WSImages myImage = new WSImages();
		// Call ListIMages to list images available on server
		Console.WriteLine("Images available:");
		string[]imgList= myImage.ListImages();
		for(int i=0; i<imgList.Length;i++)
		{
			Console.WriteLine(Path.GetFileName(imgList[i]));
		}
		try 
		{
			string imgName="";
			while(imgName.ToUpper() != "Q")
			{
				Console.Write("Image to Retrieve (Q to quit): ");
				imgName = Console.ReadLine();
				if(imgName.Trim().Length>1)
				{
					byte[] image = myImage.GetImage(imgName);    // call web service method
					MemoryStream memStream = new MemoryStream(image); 
					Console.WriteLine("Size of returned image in bytes: {0}",memStream.Length);
					Bitmap bm = new Bitmap(memStream); 
					// Can save file using following syntax.
					//bm.Save("c:\\stanwyck.jpg",System.Drawing.Imaging.ImageFormat.Jpeg);
				}
			}
		}
		catch (WebException ex)
		{
			Console.WriteLine(ex.Message);
			Console.Read();
		}
		catch (Exception ex)
		{
			Console.WriteLine(ex.Message);
			Console.Read();
		}						
	}
}