<%@ WebService Language="C#" Class="WSImages" %>
using System;
using System.Web.Services;
using System.IO;
using System.Web.Services.Protocols;
// Zwraca obrazy typu .gif z podkatalogu ./obrazy
public class WSImages: System.Web.Services.WebService 
{
	[WebMethod(Description="Pobiera obraz")]
	public byte[] GetImage(string imgName) 
	{
		byte[] imgArray;
		 
   		string filePath = Server.MapPath(@"./obrazy/"+imgName+".gif");   
   		imgArray = getBinaryFile(filePath);
        // Zgasza wyjtek jeli nie mona otworzy pliku z obrazem
		if (imgArray.Length <2) 
		{
			throw new SoapException("Nie mona otworzy pliku obrazu "+filePath+" na serwerze.",SoapException.ServerFaultCode);
		} else 
		{
			return(imgArray);
		}
	}
	[WebMethod(Description="Listuje obrazy")]
	public string[] ListImages()
	{
		string filePath = Server.MapPath(@"./obrazy/"); 
		return(Directory.GetFiles(filePath,"*.gif"));	
	}
	public byte[] getBinaryFile(string filename) 
	{
		if(File.Exists(filename)) 
		{
			try 
			{
				FileStream s=File.OpenRead(filename);
				return ConvertStreamToByteBuffer(s);
			} 
			catch(Exception e)
			{ return new byte[0]; }
		} else 
		{
			return new byte[0];
		}
	}

	public byte[] ConvertStreamToByteBuffer(Stream imgStream) 
	{
		int imgByte;
		MemoryStream tempStream = new MemoryStream();
		while((imgByte=imgStream.ReadByte())!=-1) 
		{
			tempStream.WriteByte(((byte)imgByte));
		}
		return tempStream.ToArray();  //obraz jest tablic bajtw
	}
}