using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Net;
using System.IO;

// Kompilacja: csc /t:winexe webrequest.cs

namespace HTTPBrowser
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.TextBox txt_URL;
		private System.Windows.Forms.Button btnURL;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.TextBox tbIP;
		private System.Windows.Forms.Label lblServer;
		private System.Windows.Forms.TextBox HTMLViewer;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
        private void InitializeComponent()
        {
            this.txt_URL = new System.Windows.Forms.TextBox();
            this.btnURL = new System.Windows.Forms.Button();
            this.label1 = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.tbIP = new System.Windows.Forms.TextBox();
            this.HTMLViewer = new System.Windows.Forms.TextBox();
            this.lblServer = new System.Windows.Forms.Label();
            this.SuspendLayout();
            // 
            // txt_URL
            // 
            this.txt_URL.Location = new System.Drawing.Point(19, 21);
            this.txt_URL.Name = "txt_URL";
            this.txt_URL.Size = new System.Drawing.Size(389, 20);
            this.txt_URL.TabIndex = 0;
            // 
            // btnUrl
            // 
            this.btnURL.Location = new System.Drawing.Point(429, 21);
            this.btnURL.Name = "btnUrl";
            this.btnURL.Size = new System.Drawing.Size(75, 23);
            this.btnURL.TabIndex = 1;
            this.btnURL.Text = "Adres URL";
            this.btnURL.Click += new System.EventHandler(this.btnURL_Click);
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(18, 64);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(36, 13);
            this.label1.TabIndex = 2;
            this.label1.Text = "Serwer";
            // 
            // label2
            // 
            this.label2.AutoSize = true;
            this.label2.Location = new System.Drawing.Point(18, 119);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(48, 13);
            this.label2.TabIndex = 4;
            this.label2.Text = "Adresy IP";
            // 
            // tbIP
            // 
            this.tbIP.Location = new System.Drawing.Point(19, 144);
            this.tbIP.Multiline = true;
            this.tbIP.Name = "tbIP";
            this.tbIP.Size = new System.Drawing.Size(92, 70);
            this.tbIP.TabIndex = 5;
            // 
            // HTMLViewer
            // 
            this.HTMLViewer.Location = new System.Drawing.Point(118, 144);
            this.HTMLViewer.Multiline = true;
            this.HTMLViewer.Name = "HTMLViewer";
            this.HTMLViewer.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
            this.HTMLViewer.Size = new System.Drawing.Size(386, 176);
            this.HTMLViewer.TabIndex = 6;
            this.HTMLViewer.WordWrap = false;
            // 
            // lblServer
            // 
            this.lblServer.BackColor = System.Drawing.SystemColors.Window;
            this.lblServer.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.lblServer.Location = new System.Drawing.Point(19, 86);
            this.lblServer.Name = "lblServer";
            this.lblServer.Size = new System.Drawing.Size(485, 23);
            this.lblServer.TabIndex = 7;
            // 
            // Form1
            // 
            this.AutoScaleDimensions = new System.Drawing.SizeF(6F, 13F);
            this.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
            this.ClientSize = new System.Drawing.Size(516, 332);
            this.Controls.Add(this.lblServer);
            this.Controls.Add(this.HTMLViewer);
            this.Controls.Add(this.tbIP);
            this.Controls.Add(this.label2);
            this.Controls.Add(this.label1);
            this.Controls.Add(this.btnURL);
            this.Controls.Add(this.txt_URL);
            this.Name = "Form1";
            this.Text = "WebRequest";
            this.ResumeLayout(false);
            this.PerformLayout();

        }
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		        private void btnURL_Click(object sender, EventArgs e)
        {
            // Pobiera stron internetow z danego adresu URL
            HttpWebRequest request;
            HttpWebResponse response;
            if (txt_URL.Text.Length > 0)
            {
                lblServer.Text = "";
                tbIP.Text = "";
                string serverPath = txt_URL.Text;
                string url = "http://" + serverPath;
                // Tworzy danie
                request = (HttpWebRequest)WebRequest.Create(url);
                request.Timeout = 7000; // Limit czasu to siedem sekund
                try
                {
                    response = (HttpWebResponse)
                                request.GetResponse();
                    lblServer.Text = response.Server;
                    // Pobiera strumie do przesyania rda strony 
                    Stream s = response.GetResponseStream();
                    string strContents = new
                       StreamReader(s).ReadToEnd();
                    // Umieszcza rdo strony w polu tekstowym
                    HTMLViewer.Text = strContents;
                    s.Close();
                    ListIP(serverPath); // Wywietla adres IP
                }
                catch (Exception ex)
                {
                    label1.Text = "Wpisz nazw domeny.";
                }
            }
        }


        private void ListIP(string uri)
        {
            // Wywietla adresy IP z tej domeny
            // Do okrelenia adresu IP uywana jest jedynie cz URI, okrelajca nazw serwera 
            int ndx = uri.IndexOf("/");
            if (ndx > 0) uri = uri.Substring(0, ndx);
            string ips = "";
            // Pobiera list adresw IP dla danego URI
            IPHostEntry IPHost = Dns.GetHostByName(uri);
            foreach (IPAddress addr in IPHost.AddressList)
                ips += addr.ToString() + "\r\n";
            tbIP.Text = ips;
        }
	 	
   }
}
